<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Dashboard</title>
    <link rel="shortcut icon" type="image/x-icon" href="/assets/images/loader.png" />
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('backend1/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/backend1/css/fontawesome-iconpicker.min.css')); ?>">
    <link href="<?php echo e(asset('backend1')); ?>/css/nice-select.css" rel="stylesheet">
    <!-- Select 2 -->
    <link rel="stylesheet" href="<?php echo e(asset('/backend1/css/select2.min.css')); ?>">
    <!-- Dropify library -->
    <link href="<?php echo e(asset('backend1')); ?>/css/dropify.min.css" rel="stylesheet" />
    <!-- DataTable -->
    <link rel="stylesheet" href="<?php echo e(asset('backend1/css/dataTables.min.css')); ?>">
    <!--  Quill editor    -->
    <link rel="stylesheet" href="<?php echo e(asset('/backend1/css/ionicons.min.css')); ?>">
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
    <!-- Dropify library -->
    <link href="<?php echo e(asset('backend1')); ?>/css/dropify.min.css" rel="stylesheet" />
    <!-- Tag Editor -->
    <link rel="stylesheet" href="/backend1/plugins/tags/jquery.tag-editor.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/boxicons@latest/css/boxicons.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/metismenu/dist/metisMenu.min.css">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@48,400,0,0" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link rel="stylesheet" href="/backend1/css/toastr.css">
    <link rel="stylesheet" href="/backend1/css/style.css">
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body>
    <div id="preloader"></div>
    <div class="dashboard">
        <div class="left_sidebar">
            <header>
                <div class="sidebar">
                    <nav id="sidebar_nav" class="sidebar_nav">
                        <div class="sidebar_header text-center">
                            <a href="" class="d-flex gap-3 justify-content-center py-2 rounded"
                                style="background: linear-gradient(135deg, #7b2f8e 0%, #8e2c7c 50%, #b11f5a 100%)">
                                <img src="/frontend/images/logo-white.png" alt="" class="img-fluid" />

                            </a>
                        </div>
                        <?php echo $__env->make('layouts.backend.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </nav>
                </div>
            </header>
        </div>
        <div class="main_content">
            <div style="min-height: calc(665px - 3rem)">
                <?php echo $__env->make('layouts.backend.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="d-flex justify-content-end">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                            <?php echo $__env->yieldContent('header'); ?>
                        </ol>
                    </nav>
                </div>

                <?php echo $__env->yieldContent('content'); ?>

            </div>
            <footer class="main-footer mt-5 text-start bg-white border rounded py-2 px-3">
                <!-- Default to the left -->
                <div>
                    Powered by <a style="color: #E86B19" href="https://www.infinityinfosys.com"> Infinity Infosys Pvt.
                        Ltd.</a>
                </div>
            </footer>
        </div>
    </div>



    <script src="<?php echo e(asset('backend1/js/jquery.bundle.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/metismenujs/dist/metismenujs.min.js"></script>
    <!-- DataTable -->
    <script src="/backend1/js/jquery.dataTables.min.js"></script>
    <script src="/backend1/js/jquery.nestable.js"></script>
    <!--  Dropify  -->
    <script type="text/javascript" src="<?php echo e(asset('backend1')); ?>/js/dropify.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('backend1')); ?>/js/jquery.nice-select.min.js"></script>
    <!--  jQuery Validation   -->
    <script type="text/javascript" src="<?php echo e(asset('backend1')); ?>/js/jquery.validate.min.js"></script>
    <!-- Select2 -->
    <script src="<?php echo e(asset('backend1/js/select2.full.min.js')); ?>"></script>
    <script type="text/javascript" src="/backend1/js/toastr.js"></script>
    <!--  Bootstrap Datepicker  -->
    <script type="text/javascript" src="<?php echo e(asset('backend1')); ?>/js/bootstrap-datepicker.js"></script>
    <script src="<?php echo e(asset('backend1')); ?>/js/moment.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('backend1')); ?>/js/jquery.mask.min.js"></script>
    <script src="<?php echo e(asset('backend1')); ?>/js/bootstrap-datetimepicker.min.js"></script>

    <!--  Summernote editor    -->
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <!-- Tag Editor -->
    <script src="/backend1/plugins/tags/jquery.caret.min.js" charset="utf-8"></script>
    <script src="/backend1/plugins/tags/jquery.tag-editor.js" charset="utf-8"></script>
    <script src="/backend1/js/script.js" charset="utf-8"></script>

    <?php echo $__env->yieldContent('scripts'); ?>
    <?php echo $__env->make('layouts.backend.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script type="text/javascript">
        MetisMenu.attach('#menu');
        (function() {
            "use strict";
            /**
             * Easy selector helper function
             */
            const select = (el, all = false) => {
                el = el.trim()
                if (all) {
                    return [...document.querySelectorAll(el)]
                } else {
                    return document.querySelector(el)
                }
            }

            /**
             * Preloader
             */
            let preloader = select('#preloader');
            if (preloader) {
                window.addEventListener('load', () => {
                    preloader.remove()
                });
            }

        })()
    </script>
    <script src="/backend1/js/imageupload/image-uploader.min.js" rel="stylesheet"></script>
    <script>
        $(function() {
            $('.input-images-2').imageUploader({
                imagesInputName: 'insidepages',
                extensions: ['.png'],
                maxSize: 9000,
                maxFiles: 8,
                label: 'Drag & Drop files here or click to Choose'
            });
        });
    </script>



</body>

</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/layouts/backend/main.blade.php ENDPATH**/ ?>