<?php $__env->startSection('header'); ?>
<li class="breadcrumb-item active">Candidate</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Candidate List
                </span>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-hover table-bordered data-table">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Address</th>
                            <th>Applied For</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $candidates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $candidate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($candidate->name); ?></td>
                            <td><?php echo e($candidate->phone_number); ?></td>
                            <td><?php echo e($candidate->current_address); ?></td>
                            <td><?php echo e($candidate->post_name); ?></td>
                            <td>


                                <a href="<?php echo e(route('candidates.show', $candidate)); ?>" class="text-success fs-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" width="20">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                </a>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('candidate-delete')): ?>
                                <a type="button" class="text-danger fs-4 ps-2" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($candidate->id); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.4 22.169" fill="currentColor" width="16">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.4">
                                            <path data-name="Rectangle 2" d="M8.238.7h2.923a2 2 0 012 2v.769h0-6.923 0V2.7a2 2 0 012-2z"></path>
                                            <path data-name="Line 1" d="M.7 3.469h18"></path>
                                            <path data-name="Path 77" d="M14.649 21.469h-9.9a1.385 1.385 0 01-1.38-1.279L2.085 3.469h15.231L16.029 20.19a1.385 1.385 0 01-1.38 1.279z"></path>
                                            <path data-name="Line 2" d="M7.623 6.238V18.7"></path>
                                            <path data-name="Line 3" d="M11.777 6.238V18.7"></path>
                                        </g>
                                    </svg>
                                </a>
                                <div id="deleteModal<?php echo e($candidate->id); ?>" class="delete-modal modal fade" role="dialog">
                                    <!-- Delete Modal -->
                                    <div class="modal-dialog modal-sm">
                                        <div class="modal-content">
                                            <div class="modal-body text-center">
                                                <h4 class="modal-heading">Are You Sure ?</h4>
                                                <p>Do you really want to delete these records? This process cannot be undone.</p>
                                            </div>
                                            <div class="modal-footer">
                                                <?php echo Form::open(['method' => 'DELETE', 'route' => ['candidates.destroy', $candidate]]); ?>

                                                <?php echo Form::reset("No", ['class' => 'btn btn-gray', 'data-bs-dismiss' => 'modal']); ?>

                                                <?php echo Form::submit("Yes", ['class' => 'btn btn-danger']); ?>

                                                <?php echo Form::close(); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </td>
                        </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/backend/candidates/candidate-index.blade.php ENDPATH**/ ?>