<?php $__env->startSection('title', $joblist->title); ?>

<?php $__env->startSection('headerTitle', $joblist->title); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"> <a href="<?php echo e(route('career.index')); ?>">Career</a> </li>
    <li class="breadcrumb-item active"><?php echo e($joblist->title); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="Vacancy for <?php echo e($joblist->title); ?> - <?php echo e(get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description" content="<?php echo e(get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="Vacancy for <?php echo e($joblist->title); ?> - <?php echo e(get_option('title')); ?>">
    <meta name="og:description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <link rel='stylesheet'
        href='https://cdn-uicons.flaticon.com/3.0.0/uicons-regular-rounded/css/uicons-regular-rounded.css'>
    <style>
        .services-details__content-text1 ul {
            list-style-type: disc;
            padding-left: 16px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e($joblist->title); ?></h1>
    <section class="sidebar-page-container left-sidebar">
        <div class="container">
            <div class="row clearfix">
                <!--Start Services Details Sidebar-->

                <!--End Services Details Sidebar-->
                <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar">

                        <div class="project-widget">
                            <ul class="project-detail_info">
                                <li>
                                    <i class="fi fi-rr-users"></i>
                                    Job Title:
                                    <span><?php echo e($joblist->title); ?></span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-folder-tree"></i>
                                    Employment Type:
                                    <span><?php echo e($joblist->time); ?></span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-clock-five"></i>
                                    No. of Vacancy:
                                    <span><?php echo e($joblist->no_of_vacancy); ?></span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-graduation-cap"></i>
                                    Education:
                                    <span><?php echo e($joblist->education); ?></span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-flask-potion"></i>
                                    Experience:
                                    <span><?php echo e($joblist->experince); ?></span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-payroll"></i>
                                    Salary:
                                    <span><?php echo e($joblist->salary); ?></span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-calendar"></i>
                                    Deadline:
                                    <span><?php echo e($joblist?->deadline?->format('d M, Y') ?? '-'); ?></span>
                                </li>
                            </ul>
                        </div>

                    </aside>
                </div>
                <!--Start Services Details Content-->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <div class="service-detail service__detail">
                        <h2 class="service-detail_title"><?php echo e($joblist->title); ?></h2>

                        <?php echo $joblist->description; ?>



                        <div class="about-one_button">
                            <a href="<?php echo e(route('career.apply', $joblist)); ?>" class="theme-btn btn-style-one">
                                <span class="btn-wrap">
                                    <span class="text-one">Apply Now</span>
                                    <span class="text-two">Apply Now</span>
                                </span>
                            </a>
                        </div>
                    </div>
                </div>
                <!--End Services Details Content-->
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(".service__detail li").each(function() {
            if (!$(this).find(".flaticon-checked").length) {
                $(this).prepend('<i class="flaticon-checked"></i> ');
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/careers/career-show.blade.php ENDPATH**/ ?>