<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">

    <?php if(Nav::isRoute('product.index')): ?>
        <link rel="stylesheet" href="/css/app.css">
    <?php endif; ?>
    <!-- Stylesheets -->
    <link href="/frontend/css/bootstrap.css" rel="stylesheet">
    <link href="/frontend/css/style.css" rel="stylesheet">
    <link href="/frontend/css/responsive.css" rel="stylesheet">

    <!-- Color Switcher Mockup -->
    <link href="/frontend/css/color-switcher-design.css" rel="stylesheet">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Work+Sans:ital,wght@0,100..900;1,100..900&amp;display=swap"
        rel="stylesheet">

    <link rel="shortcut icon" href="/frontend/images/favicon.png" type="image/x-icon">
    <link rel="icon" href="/frontend/images/favicon.png" type="image/x-icon">

    <!-- Responsive -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="/frontend/images/favicon.jpeg" />
    <link rel="icon" type="image/jpeg" sizes="32x32" href="/frontend/images/favicon.jpeg" />
    <link rel="icon" type="image/jpeg" sizes="16x16" href="/frontend/images/favicon.jpeg" />
    <link rel="manifest" href="/frontend/images/favicon.jpeg" />
    <link rel="shortcut icon" type="image/x-icon" href="/frontend/images/favicon.jpeg">

    <?php if(Nav::isRoute('page.index')): ?>
        <title><?php echo e(get_option('seo_title') ? get_option('seo_title') : get_option('title')); ?></title>
    <?php else: ?>
        <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(get_option('title')); ?></title>
    <?php endif; ?>

    <meta property="og:site_name" content="<?php echo e(get_option('title')); ?>">


    <?php echo $__env->yieldContent('meta'); ?>

    <link rel="stylesheet" href="/backend1/css/toastr.css">
    <?php echo $__env->yieldContent('styles'); ?>

    <?php $__currentLoopData = get_plugins('Header'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $plugin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $plugin->code; ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</head>

<body>
    <?php $__currentLoopData = get_plugins('Body'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $plugin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $plugin->code; ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <div class="page-wrapper">

        <!-- Cursor -->
        <div class="cursor"></div>
        <div class="cursor-follower"></div>
        <!-- Cursor End -->

        <!-- Preloader -->
        <div class="preloader"></div>
        <!-- End Preloader -->

        <!-- Main Header -->
        <?php echo $__env->make('layouts.frontend.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End Main Header -->

        <?php if(!Nav::isRoute('page.index')): ?>
            <section class="page-title" style="background-image:url(/frontend/images/banners/breadcrumb.png)">
                <div class="auto-container">
                    <h2><?php echo $__env->yieldContent('headerTitle'); ?></h2>
                    <ul class="bread-crumb clearfix">
                        <li><a href="<?php echo e(route('page.index')); ?>">Home</a></li>
                        <?php echo $__env->yieldContent('header'); ?>
                    </ul>
                </div>
            </section>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>


        <!-- Main Footer -->
        <?php echo $__env->make('layouts.frontend.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End Footer Style -->

        <!-- Search Popup -->
        <div class="search-popup">
            <div class="color-layer"></div>
            <button class="close-search"><span class="flaticon-close"></span></button>
            <form method="post" action="https://themazine.com/html/fllopi/blog.html">
                <div class="form-group">
                    <input type="search" name="search-field" value="" placeholder="Search Here" required="">
                    <button class="fa fa-solid fa-magnifying-glass fa-fw" type="submit"></button>
                </div>
            </form>
        </div>
        <!-- End Search Popup -->


    </div>
    <!-- End PageWrapper -->

    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>

    <script src="/js/app.js" charset="utf-8"></script>
    <script src="/frontend/js/jquery.js"></script>
    <script src="/frontend/js/popper.min.js"></script>
    <script src="/frontend/js/bootstrap.min.js"></script>
    <script src="/frontend/js/appear.js"></script>
    <script src="/frontend/js/parallax.min.js"></script>
    <script src="/frontend/js/tilt.jquery.min.js"></script>
    <script src="/frontend/js/jquery.paroller.min.js"></script>
    <script src="/frontend/js/wow.js"></script>
    <script src="/frontend/js/swiper.min.js"></script>
    <script src="/frontend/js/backtotop.js"></script>
    <script src="/frontend/js/odometer.js"></script>
    <script src="/frontend/js/parallax-scroll.js"></script>

    <script src="/frontend/js/gsap.min.js"></script>
    <script src="/frontend/js/SplitText.min.js"></script>
    <script src="/frontend/js/ScrollTrigger.min.js"></script>
    <script src="/frontend/js/ScrollToPlugin.min.js"></script>
    <script src="/frontend/js/ScrollSmoother.min.js"></script>

    <script src="/frontend/js/magnific-popup.min.js"></script>
    <script src="/frontend/js/jquery.meanmenu.min.js"></script>
    <script src="/frontend/js/nav-tool.js"></script>
    <script src="/frontend/js/jquery-ui.js"></script>
    <script src="/frontend/js/jquery.countdown.js"></script>
    <script src="/frontend/js/element-in-view.js"></script>
    <script src="/frontend/js/color-settings.js"></script>
    <?php if(Nav::isRoute('product.show')): ?>
        <script src="/frontend/js/touchspin.js"></script>
    <?php endif; ?>
    <script src="/frontend/js/script.js"></script>

    <script type="text/javascript" src="/backend1/js/toastr.js"></script>


    <?php echo $__env->yieldContent('scripts'); ?>
    <?php echo $__env->make('layouts.backend.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        (function() {
            function c() {
                var b = a.contentDocument || a.contentWindow.document;
                if (b) {
                    var d = b.createElement('script');
                    d.innerHTML =
                        "window.__CF$cv$params={r:'9bbb1f7a090e98d6',t:'MTc2ODAzNzA4My4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='https://themazine.com/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";
                    b.getElementsByTagName('head')[0].appendChild(d)
                }
            }
            if (document.body) {
                var a = document.createElement('iframe');
                a.height = 1;
                a.width = 1;
                a.style.position = 'absolute';
                a.style.top = 0;
                a.style.left = 0;
                a.style.border = 'none';
                a.style.visibility = 'hidden';
                document.body.appendChild(a);
                if ('loading' !== document.readyState) c();
                else if (window.addEventListener) document.addEventListener('DOMContentLoaded', c);
                else {
                    var e = document.onreadystatechange || function() {};
                    document.onreadystatechange = function(b) {
                        e(b);
                        'loading' !== document.readyState && (document.onreadystatechange = e, c())
                    }
                }
            }
        })();
    </script>
</body>

</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/layouts/frontend/main.blade.php ENDPATH**/ ?>