<?php $__env->startSection('headerTitle', 'Blog By ' . $blogCategory->title); ?>

<?php $__env->startSection('title', 'Blog By ' . $blogCategory->title); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active">Blog By <?php echo e($blogCategory->title); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="Blog by <?php echo e($blogCategory->title); ?> - <?php echo e(get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description" content="<?php echo e(get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="Blog by <?php echo e($blogCategory->title); ?> - <?php echo e(get_option('title')); ?>">
    <meta name="og:description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .page-pagination {
            margin-top: 20px;
            text-align: center;
        }

        .page-pagination ul {
            justify-content: center;
            padding: 0;
            margin: 0;
        }

        .page-pagination ul li a,
        .page-pagination ul li span {
            display: flex;
            text-decoration: none;
            justify-content: center;
            align-items: center;
            background: var(--accent-color);
            color: var(--white-color);
            width: 40px;
            height: 40px;
            margin: 0 5px;
            font-weight: 700;
            line-height: 1em;
            transition: all 0.3s ease-in-out;
        }

        .page-pagination ul li.active a,
        .page-pagination ul li a:hover {
            background: var(--suntop-base);
            color: #FFF;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none">Blog By <?php echo e($blogCategory->title); ?> - <?php echo e(get_option('title')); ?></h1>
    <div class="blog-one section-gap">
        <div class="container">
            <div class="blog-one__bottom">
                <div class="blog-posts-container">
                    <div class="row g-4">

                        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay=".3s">
                                <div class="blog-one__single h-100">
                                    <div class="blog-one__single-img">
                                        <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>">
                                    </div>

                                    <div class="blog-one__single-content" style="height: calc(100% - 248.66px)">
                                        <h2>
                                            <a href="<?php echo e(route('blog.show', $item)); ?>"><?php echo e($item->title); ?></a>
                                        </h2>
                                        

                                        <div class="blog-one__single-content-bottom">
                                            <div class="author-info">

                                                <div class="text-box ms-0">
                                                    <h4><?php echo e($item->category ? $item->category->title : ''); ?></h4>
                                                    <p><?php echo e($item->created_at ? $item->created_at->format('d M, Y') : ''); ?>

                                                    </p>
                                                </div>
                                            </div>

                                            <div class="btn-box">
                                                <a href="<?php echo e(route('blog.show', $item)); ?>">Read More <span
                                                        class="icon-right-arrow"></span></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>


                </div>

                <!-- Page Pagination Start -->
                <div class="page-pagination wow fadeInUp" data-wow-delay="1.2s">
                    <?php echo e($blogs->links()); ?>

                </div>
                <!-- Page Pagination End -->
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/frontend/blog_categories/category-index.blade.php ENDPATH**/ ?>