<?php $__env->startSection('title', $category->seo_title ? $category->seo_title : $category->title); ?>

<?php $__env->startSection('headerTitle', $category->seo_title ? $category->seo_title : $category->title); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active"><?php echo e($category->title); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="/assets/css/module-css/shop.css" />
    <style>
        .hidden {
            display: none !important;
        }

        /* Responsive */
        .mobile__filter {
            display: none;
        }

        @media  screen and (max-width: 1200px) {
            .mobile__filter {
                display: block;
                /* width: 100%; */
            }

            .desktop__filter {
                display: none;
            }
        }

        /* Filter */
        .category__list {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-orient: horizontal;
            -webkit-box-direction: normal;
            -ms-flex-flow: row wrap;
            flex-flow: row wrap;
            -webkit-box-align: baseline;
            -ms-flex-align: baseline;
            align-items: baseline;
            margin: 0;
            padding-left: 17px !important;
            grid-gap: 10px;
            padding-bottom: 20px;
            /* margin-bottom: 15px; */
            /* border-bottom: 1px solid #d4d5d9; */
        }

        .category__list li {
            list-style: none;
        }

        .category__item {
            position: relative;
            background-color: #fff;
            text-transform: capitalize;
            color: #3e4152;
            cursor: default;
            font-size: 14px;
            padding: 6px 36px 5px 20px;
            -webkit-transition: all 0.2s ease-out;
            transition: all 0.2s ease-out;
            border-radius: 20px;
            border: 1px solid #d4d5d9;
        }

        .filter-summary-removeFilter {
            position: absolute;
            top: 4px;
            right: 4px;
            width: 18px;
            height: 20px;
            z-index: 1;
            text-align: center;
            cursor: pointer;
            right: 10px;
            top: 6px;
            margin: 0;
        }

        .filter-summary-removeIcon {
            vertical-align: middle;
            opacity: 0.7;
            -webkit-transform: scale(0.7);
            transform: scale(0.7);
        }

        .store__widget .offcanvas-header {
            background-color: var(--crank-base);
        }

        .store__widget .offcanvas-header .h5 {
            margin-bottom: 0;
            color: white;
        }

        .store__widget .btn-close {
            background: transparent var(--bs-btn-close-bg) center/1em auto no-repeat;
            background-color: white;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e($category->seo_keyword ? $category->seo_keyword : get_option('seo_meta_keywords')); ?>">
    <meta name="description"
        content="<?php echo e($category->seo_description ? $category->seo_description : get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e($category->seo_title ? $category->seo_title : $category->title); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('assets/images/resources/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e($category->seo_description ? $category->seo_description : get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e($category->seo_title ? $category->seo_title : $category->title); ?>">
    <meta name="og:description"
        content="<?php echo e($category->seo_description ? $category->seo_description : get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('assets/images/resources/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Shop One -->
    <section class="shop-two">
        <div class="container">
            <div class="row clearfix">

                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Shop Block One -->
                    <div class="shop-block_one col-lg-3 col-md-6 col-sm-6">
                        <div class="shop-block_one-inner h-100">
                            <div class="shop-block_one-image">
                                <a href="<?php echo e(route('product.show', $item)); ?>">
                                    <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>" />
                                </a>
                            </div>
                            <div class="shop-block_one-content">
                                <h4 class="shop-block_one-heading">
                                    <a href="<?php echo e(route('product.show', $item)); ?>"><?php echo e($item->title); ?></a>
                                </h4>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



            </div>

            <!-- Styled Pagination -->
            <?php echo e($products->links()); ?>


            <!-- End Styled Pagination -->

        </div>
    </section>
    <!-- End Shop One -->


<?php $__env->stopSection(); ?>


<?php $__env->startSection('content1'); ?>
    <div id="categoryFilterContainer" data-slug="<?php echo e($category->slug); ?>"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const btn = document.getElementById("filter-toggle");
            const sidebar = document.getElementById("filter-sidebar");
            const productsCol = document.getElementById("products-col");

            btn.addEventListener("click", () => {
                sidebar.classList.toggle("hidden");

                // adjust product column width dynamically
                if (sidebar.classList.contains("hidden")) {
                    productsCol.classList.remove("col-xl-9", "col-lg-8");
                    productsCol.classList.add("col-12");
                } else {
                    productsCol.classList.remove("col-12");
                    productsCol.classList.add("col-xl-9", "col-lg-8");
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/categories/category-show.blade.php ENDPATH**/ ?>