<?php $__env->startSection('title', get_seo_page('dealer-enquiry')->seo_title ?? 'Become a Dealer'); ?>

<?php $__env->startSection('headerTitle', 'Become a Dealer'); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active">Become a Dealer</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('dealer-enquiry')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description"
        content="<?php echo e(get_seo_page('dealer-enquiry')->seo_description ?? get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title"
        content="<?php echo e(get_seo_page('dealer-enquiry')->seo_title ?? 'Dealer Enquiry - ' . get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e(get_seo_page('dealer-enquiry')->seo_description ?? get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title"
        content="<?php echo e(get_seo_page('dealer-enquiry')->seo_title ?? 'Become a Dealer - ' . get_option('title')); ?>">
    <meta name="og:description"
        content="<?php echo e(get_seo_page('dealer-enquiry')->seo_description ?? get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e(get_seo_page('dealer-enquiry')->seo_title ?? 'Become a Dealer - ' . get_option('title')); ?></h1>
    <div class="faq-one">
        <div class="container">
            <div class="position-relative">
                <div class="title-box">
                    <h3>Become a dealer</h3>
                    <div class="text">
                        Partner with us as a dealer and grow your business with a trusted supplier of premium building
                        materials in Nepal, <br> offering high-quality products, reliable support, and long-term growth
                        opportunities.
                    </div>
                </div>
            </div>
            <div class="contact-page__inner">

                <div class="row align-items-center">
                    <div class="col-xl-6">
                        <div class="contact-page__left">
                            <img src="/frontend/images/banners/dealer.png" class="w-100" alt="">
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="contact-form">
                            <form id="contact-form" class=" contact-page__form"
                                action="<?php echo e(route('dealer_enquiry.store')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-xl-12">
                                        <h2 class="fs-1">Feel free to fill the form</h2>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                        <div class="contact-page__input-box">
                                            <input type="text" name="name" placeholder="Your name"
                                                value="<?php echo e(old('name')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                        <div class="contact-page__input-box">
                                            <input type="email" name="email" value="<?php echo e(old('email')); ?>"
                                                placeholder="Your Email" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                        <div class="contact-page__input-box">
                                            <input type="text" placeholder="Mobile Number"
                                                value="<?php echo e(old('phone_number')); ?>" name="phone_number" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                        <div class="contact-page__input-box">
                                            <input type="text" placeholder="Company Name" name="company_name"
                                                value="<?php echo e(old('company_name')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                        <div class="contact-page__input-box">
                                            <input type="text" placeholder="PAN No." name="pan_number"
                                                value="<?php echo e(old('pan_number')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6 form-group">
                                        <div class="contact-page__input-box">
                                            <input type="text" placeholder="Address" name="address"
                                                value="<?php echo e(old('address')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="col-xl-12 form-group">
                                        <div class="contact-page__input-box text-message-box">
                                            <textarea name="message" placeholder="Your Query" required=""><?php echo e(old('message')); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 form-group">

                                        <div class="contact-page__btn-box">
                                            <button type="submit" class="theme-btn btn-style-one">
                                                <span class="btn-wrap">
                                                    <span class="text-one">Send Message</span>
                                                    <span class="text-two">Send Message</span>
                                                </span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="result"></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/dealers/dealer-index.blade.php ENDPATH**/ ?>