<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"> <a href="<?php echo e(route('events.index')); ?>">Event List</a> </li>
    <li class="breadcrumb-item active">View Event</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        Event Details
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <ul class="list-group">
                                <li class="list-group-item text-center">
                                    <img style="height: 120px; object-fit: contain" src="<?php echo e($event->imageUrl); ?>"
                                        alt="">
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Title : </strong> <?php echo e($event->title); ?>

                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Location : </strong> <?php echo e($event->location); ?>

                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Status : </strong>
                                    <?php if($event->status == 1): ?>
                                        <label class="text-success p-2">Active</label>
                                    <?php else: ?>
                                        <label class="text-warning p-2">Disable</label>
                                    <?php endif; ?>
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Created At:</strong>
                                    <?php echo e($event?->created_at?->format('d M, Y')); ?>

                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Description : </strong> <?php echo $event->description; ?>

                                </li>
                            </ul>
                        </div>

                        <div class="col-md-6">
                            <?php if(count(json_decode($event->images) ?? [])): ?>
                                <div class="row g-4">
                                    <?php $__currentLoopData = json_decode($event->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6">
                                            <img class="w-100" src="/frontend/images/events/<?php echo e($item); ?>"
                                                alt="">
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/backend/events/event-show.blade.php ENDPATH**/ ?>