<?php $__env->startSection('title', $blog->seo_title ?? $blog->title); ?>

<?php $__env->startSection('headerTitle', $blog->title); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('blog.index')); ?>">Blogs</a></li>
    <li><span class="icon-right-arrow"></span></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e($blog->title); ?></li>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e($blog->seo_keyword ?? get_option('seo_meta_keywords')); ?> ">
    <meta name="description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e($blog->seo_title ?? $blog->title); ?> }}">
    <meta name="twitter:image" content="<?php echo e(asset('frontend/images/blogs/' . $blog->image)); ?>">
    <meta name="twitter:description" content="<?php echo e(get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e($blog->seo_title ?? $blog->title); ?> }}">
    <meta name="og:description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('frontend/images/blogs/' . $blog->image)); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e($blog->seo_title ?? $blog->title); ?></h1>
    <section class="blog-details">
        <div class="container">
            <div class="row">
                <!--Start Blog Details Content-->
                <div class="col-xl-8">
                    <div class="blog-details__content">
                        <div class="blog-details__content-top">
                            <div class="blog-details__content-top-img">
                                <img src="<?php echo e($blog->imageUrl); ?>" alt="<?php echo e($blog->title); ?>">
                            </div>

                            <div class="blog-details__content-top-content">

                                <ul class="meta-box">
                                    <li>
                                        <p>
                                            <span class="icon-calendar"></span> <a href="#">
                                                <?php echo e($blog->created_at ? $blog->created_at->format('d M, Y') : ''); ?>

                                            </a>
                                        </p>
                                    </li>
                                    <li>
                                        <p><span class="icon-user"></span> <a href="#">Admin</a></p>
                                    </li>
                                    <li>
                                        <p><span class="icon-bubble-chat"></span> <a
                                                href="#"><?php echo e($blog->category ? $blog->category->title : ''); ?></a></p>
                                    </li>
                                </ul>
                                <h2><?php echo e($blog->title); ?></h2>

                                <div class="blog-details__content-description">
                                    <?php echo $blog->description; ?>

                                </div>

                            </div>
                        </div>


                        <div class="blog-details__content-text3">
                            <div class="blog-details__content-text3-tag">

                            </div>

                            <div class="blog-details__content-text3-share">
                                <div class="title-box">
                                    <h2>Share:</h2>
                                </div>

                                <ul>
                                    <li>
                                        <a href="https://facebook.com/sharer/sharer.php?u=<?php echo e(request()->url()); ?>">
                                            <span class="icon-facebook-app-symbol"></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="https://twitter.com/intent/tweet?text=<?php echo e($blog->title); ?>&url=<?php echo e(request()->url()); ?>">
                                            <span class="icon-twitter-1"></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="https://www.linkedin.com/shareArticle?url=<?php echo e(request()->url()); ?>&title=<?php echo e($blog->title); ?>">
                                            <span class="icon-linkedin-big-logo"></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="https://www.pinterest.com/pin/create/button?url=<?php echo e($blog->title); ?>&media=<?php echo e($blog->imageUrl); ?>&description=<?php echo e($blog->title); ?>">
                                            <span class="icon-pinterest"></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                    </div>
                </div>
                <!--End Blog Details Content-->

                <!--Start Sidebar-->
                <div class="col-xl-4">
                    <div class="sidebar">
                        <!--Start Sidebar Single-->
                        <div class="sidebar__single sidebar__search wow fadeInUp" data-wow-delay=".1s">
                            <form action="/blogs" method="GET" class="sidebar__search-form">
                                <input type="search" name="search" placeholder="Search...">
                                <button type="submit"><i class="fa fa-search"></i></button>
                            </form>
                        </div>
                        <!--End Sidebar Single-->

                        <!--Start Sidebar Single-->
                        <div class="sidebar__single sidebar__services wow fadeInUp" data-wow-delay=".1s">
                            <div class="title-box">
                                <h2>Category</h2>
                            </div>

                            <ul class="sidebar__services-list">
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e(route('blog_category.show', $item)); ?>">
                                            <?php echo e($item->title); ?> <span class="icon-right-arrow"></span>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <!--End Sidebar Single-->

                        <!--Start Sidebar Single-->
                        <div class="sidebar__single sidebar__recent-post wow fadeInUp" data-wow-delay=".1s">
                            <div class="title-box">
                                <h2>Recent Post</h2>
                            </div>

                            <ul class="sidebar__recent-post-list">
                                <?php $__currentLoopData = $blogs->except($blog->id)->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <div class="img-box">
                                            <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>">
                                        </div>

                                        <div class="text-box">
                                            <p><span class="icon-calendar"></span> 20 Jun, 2025</p>
                                            <h3><a href="#">We won best factory award <br> of the ...</a></h3>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </ul>
                        </div>
                        <!--End Sidebar Single-->


                    </div>
                </div>
                <!--End Sidebar-->
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/frontend/blogs/blog-show.blade.php ENDPATH**/ ?>