<?php $__env->startSection('title', $event->seo_title ?? $event->title); ?>

<?php $__env->startSection('headerTitle', $event->title); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('event.index')); ?>">Events</a></li>
    <li><span class="icon-right-arrow"></span></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e($event->title); ?></li>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e($event->seo_keyword ?? get_option('seo_meta_keywords')); ?> }}">
    <meta name="description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e($event->seo_title ?? $event->title); ?> - <?php echo e(get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('frontend/images/events/' . $event->image)); ?>">
    <meta name="twitter:description" content="<?php echo e(get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e($event->seo_title ?? $event->title); ?> - <?php echo e(get_option('title')); ?>">
    <meta name="og:description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('frontend/images/events/' . $event->image)); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e($event->seo_title ?? $event->title); ?> - <?php echo e(get_option('title')); ?></h1>
    <section class="services-details">
        <div class="container">
            <div class="row justify-content-center">


                <!--Start Services Details Content-->
                <div class="col-xl-9">
                    <div class="services-details__content">
                        <div class="services-details__content-img">
                            <section class="main-slider">
                                <div class="swiper-container event-slider__carousel">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <img src="<?php echo e($event->imageUrl); ?>" alt="<?php echo e($event->title); ?>">
                                        </div>
                                        <?php if(count(json_decode($event->images) ?? [])): ?>
                                            <?php $__currentLoopData = json_decode($event->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="swiper-slide">
                                                    <img src="/frontend/images/events/<?php echo e($item); ?>" alt="">
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php endif; ?>

                                    </div>
                                    <!-- If we need navigation buttons -->
                                </div>


                            </section>
                        </div>

                        <div class="services-details__content-text1">
                            <div class="title-box">
                                <h2 class="fs-3"><?php echo e($event->title); ?></h2>
                                <p><?php echo e($event->location); ?></p>
                            </div>

                            <p class="text1">
                                <?php echo $event->description; ?>

                            </p>


                        </div>


                        <div class="blog-details__content-text3">

                            <div class="blog-details__content-text3-share">
                                <div class="title-box">
                                    <h2>Share:</h2>
                                </div>

                                <ul>
                                    <li>
                                        <a href="https://facebook.com/sharer/sharer.php?u=<?php echo e(request()->url()); ?>">
                                            <span class="icon-facebook-app-symbol"></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="https://twitter.com/intent/tweet?text=<?php echo e($event->title); ?>&url=<?php echo e(request()->url()); ?>">
                                            <span class="icon-twitter-1"></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="https://www.linkedin.com/shareArticle?url=<?php echo e(request()->url()); ?>&title=<?php echo e($event->title); ?>">
                                            <span class="icon-linkedin-big-logo"></span>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="https://www.pinterest.com/pin/create/button?url=<?php echo e($event->title); ?>&media=<?php echo e($event->imageUrl); ?>&description=<?php echo e($event->title); ?>">
                                            <span class="icon-pinterest"></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>
                <!--End Services Details Content-->
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/frontend/events/event-show.blade.php ENDPATH**/ ?>