<?php $__env->startSection('header'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('users.index')); ?>">User List</a></li>
<li class="breadcrumb-item active">Edit User</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Edit User</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="form-group" method="post" action="<?php echo e(route('users.update', $user)); ?>">
                        <?php echo e(csrf_field()); ?>

                        <?php echo method_field('PUT'); ?>
                        <div class="row g-3">
                            <div class="form-group col-6">
                                <label class="control-label">User Name:</label>
                                <input class="form-control" type="text" name="name" value="<?php echo e($user->name); ?>" required>
                            </div>

                            <div class="form-group col-6">
                                <label class="control-label">User Email:</label>
                                <input class="form-control" type="email" name="email" value="<?php echo e($user->email); ?>" required>
                            </div>

                            <div class="form-group col-4">
                                <label class="control-label">New Password:</label>
                                <input class="form-control" type="Password" name="password">
                                <span>Leave empty if You dont want to change password</span>

                            </div>
                            <div class="form-group col-4">
                                <label class="control-label">Choose a Role</label>
                                <select name="role" class="form-control select2 text-capitalize" required>
                                    <option value="">Select One</option>
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role->id); ?>" <?php echo e($user->hasRole($role) == $role->id ?'selected': ''); ?> class="text-capitalize"><?php echo e($role->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-0">
                                <button class="btn btn-primary">Update User</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/backend/users/user-edit.blade.php ENDPATH**/ ?>