<?php $__env->startSection('title', get_seo_page('store')->seo_title); ?>

<?php $__env->startSection('headerTitle', get_seo_page('store')->seo_title); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active">Products</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('store')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_seo_page('store')->seo_description ?? get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e(get_seo_page('store')->seo_title ?? 'Product Store - ' . get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e(get_seo_page('store')->seo_description ?? get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e(get_seo_page('store')->seo_title ?? 'Product Store - ' . get_option('title')); ?>">
    <meta name="og:description"
        content="<?php echo e(get_seo_page('store')->seo_description ?? get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Shop One -->
    <section class="shop-two">
        <div class="container">
            <div class="row clearfix">

                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Shop Block One -->
                    <div class="shop-block_one col-lg-3 col-md-6 col-sm-6">
                        <div class="shop-block_one-inner h-100">
                            <div class="shop-block_one-image">
                                <a href="<?php echo e(route('product.show', $item)); ?>">
                                    <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>" />
                                </a>
                            </div>
                            <div class="shop-block_one-content">
                                <h4 class="shop-block_one-heading">
                                    <a href="<?php echo e(route('product.show', $item)); ?>"><?php echo e($item->title); ?></a>
                                </h4>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



            </div>

            <!-- Styled Pagination -->
            <?php echo e($products->links()); ?>


            <!-- End Styled Pagination -->

        </div>
    </section>
    <!-- End Shop One -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/products/product-index.blade.php ENDPATH**/ ?>