<?php $__env->startSection('header'); ?>
<li class="breadcrumb-item active">Dealer Enquiry</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Dealer Enquiry List
                </div>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-hovered data-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Company Name</th>
                            <th>Phone</th>
                            <th>Address</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $enquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dealer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(++$key); ?></td>
                            <td><?php echo e($dealer->name); ?></td>
                            <td><?php echo e($dealer->company_name); ?></td>
                            <td><?php echo e($dealer->phone); ?></td>
                            <td><?php echo e($dealer->address); ?></td>
                            <td>
                                <a href="<?php echo e(route('dealer_enquiries.show', $dealer)); ?>" rel="noopener noreferrer" class="text-secondary fs-5 pe-2" title="View  Details">
                                    <i class="fa fa-eye"></i>
                                </a>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dealer-enquiry-delete')): ?>
                                <a type="button" class="text-danger fs-4" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($dealer->id); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.4 22.169" fill="currentColor" width="16">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.4">
                                            <path data-name="Rectangle 2" d="M8.238.7h2.923a2 2 0 012 2v.769h0-6.923 0V2.7a2 2 0 012-2z"></path>
                                            <path data-name="Line 1" d="M.7 3.469h18"></path>
                                            <path data-name="Path 77" d="M14.649 21.469h-9.9a1.385 1.385 0 01-1.38-1.279L2.085 3.469h15.231L16.029 20.19a1.385 1.385 0 01-1.38 1.279z"></path>
                                            <path data-name="Line 2" d="M7.623 6.238V18.7"></path>
                                            <path data-name="Line 3" d="M11.777 6.238V18.7"></path>
                                        </g>
                                    </svg>
                                </a>
                                <div id="deleteModal<?php echo e($dealer->id); ?>" class="delete-modal modal fade" role="dialog">
                                    <!-- Delete Modal -->
                                    <div class="modal-dialog modal-sm">
                                        <div class="modal-content">
                                            <div class="modal-body text-center">
                                                <h4 class="modal-heading">Are You Sure ?</h4>
                                                <p>Do you really want to delete these records? This process cannot be undone.</p>
                                            </div>
                                            <div class="modal-footer">
                                                <?php echo Form::open(['method' => 'DELETE', 'route' => ['dealer_enquiries.destroy', $dealer]]); ?>

                                                <?php echo Form::reset("No", ['class' => 'btn btn-gray', 'data-bs-dismiss' => 'modal']); ?>

                                                <?php echo Form::submit("Yes", ['class' => 'btn btn-danger']); ?>

                                                <?php echo Form::close(); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/backend/dealer_enquiries/enquiry-index.blade.php ENDPATH**/ ?>