<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('suppliers.index')); ?>">Supplier List</a></li>
    <li class="breadcrumb-item active">Add Supplier</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <form class="form-group" enctype="multipart/form-data" method="post" action="<?php echo e(route('suppliers.store')); ?>">
        <?php echo csrf_field(); ?>
        <div class="row g-4">
            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-header">
                        <span class="panel-title">Create New Supplier</span>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-8">
                                <label class="form-label">Title <span class="text-danger">*</span> </label>
                                <input class="form-control" type="text" name="title" value="<?php echo e(old('title')); ?>"
                                    required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Status <span class="text-danger">*</span> </label>
                                <select class="form-select select2" name="status" required>
                                    <option value="">Select One</option>
                                    <option <?php echo e(old('status') == '1' ? 'selected' : ''); ?> value="1">
                                        Active
                                    </option>
                                    <option <?php echo e(old('status') == '0' ? 'selected' : ''); ?> value="0">
                                        Disable
                                    </option>
                                </select>
                            </div>

                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Featured Image <span class="text-danger">*</span>
                                    </label>
                                    <input class="form-control dropify" type="file" name="image" required>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-12 mt-15">
                                <button type="submit" class="btn btn-primary add_shop">Submit</button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/backend/suppliers/supplier-create.blade.php ENDPATH**/ ?>