<?php $__env->startSection('headerTitle', 'Events'); ?>

<?php $__env->startSection('title', get_seo_page('events')->seo_title ?? 'Events'); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('events')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e(get_seo_page('events')->seo_title ?? 'Events - ' . get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description" content="<?php echo e(get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e(get_seo_page('events')->seo_title ?? 'Events - ' . get_option('title')); ?>">
    <meta name="og:description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active">Events</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e(get_seo_page('events')->seo_title ?? 'Events - ' . get_option('title')); ?></h1>
    <section class="team-one">
        <div class="container">
            <div class="row">

                <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!--Start Team One Single-->
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="team-one__single">
                            <div class="team-one__img-box">
                                <a href="<?php echo e(route('event.show', $item)); ?>" class="team-one__img">
                                    <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>">
                                </a>
                            </div>

                            <div class="team-one__content">
                                <h3 class="team-one__title">
                                    <a href="<?php echo e(route('event.show', $item)); ?>">
                                        <?php echo e($item->title); ?>

                                    </a>
                                </h3>
                                <p class="team-one__sub-title"><?php echo e($item->location); ?></p>

                            </div>
                        </div>
                    </div>
                    <!--End Team Two Single-->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/frontend/events/event-index.blade.php ENDPATH**/ ?>