<?php $__env->startSection('title', get_seo_page('career')->seo_title ?? 'Our Career'); ?>

<?php $__env->startSection('headerTitle', 'Our Career'); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active">Our Career</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('career')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_seo_page('career')->seo_description ?? get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e(get_seo_page('career')->seo_title ?? 'Career - ' . get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e(get_seo_page('career')->seo_description ?? get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e(get_seo_page('career')->seo_title ?? 'Career - ' . get_option('title')); ?>">
    <meta name="og:description"
        content="<?php echo e(get_seo_page('career')->seo_description ?? get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .pricing-one__single .table-header {
            position: relative;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 1px solid #d8d8d8;
            padding-bottom: 26px;
            margin-bottom: 29px;
            transition: all 200ms linear;
            transition-delay: 0.1s;
            margin-top: 0;
            padding-top: 0;
            border-top: 0px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e(get_seo_page('career')->seo_title ?? 'Career - ' . get_option('title')); ?></h1>
    <section class="about-one">
        <div class="container">
            <div class="row align-items-center">
                <!--Start About One Img-->
                <div class="col-xl-5">
                    <div class="about-one__img wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <div class="row">

                            <div class="col-xl-12 col-lg-12 col-md-12">
                                <div class="about-one__img2">
                                    <img src="/frontend/images/abouts/about-image.png" alt="">
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!--End About One Img-->

                <!--Start About One Content-->
                <div class="col-xl-7">
                    <div class="about-one__content wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <div class="about-one__content-title sec-title-animation animation-style2">
                            <p class="title-animation">Excellence you can trust</p>
                            <h2 class="title-animation">Drive Innovation, Drive Your Career</h2>
                        </div>

                        <div class="about-one__content-text1">
                            <p>
                                At <strong>Nataraj Roofing Pvt Ltd</strong>, we don’t just sell tyres — we build journeys.
                                Grow your career with opportunities, innovation, and a team driving India forward.
                            </p>
                        </div>



                        <div class="about-one__content-text3">
                            <ul>
                                <li>
                                    🚀 Opportunities for personal & professional growth
                                </li>
                                <li>🤝 Supportive & collaborative work culture</li>
                                <li>🌍 Be part of Nepal’s leading tyre solutions brand</li>
                                <li>💡 Innovation-driven environment</li>
                            </ul>
                        </div>


                    </div>
                </div>
                <!--End About One Content-->
            </div>
        </div>
    </section>


    <section class="pricing-one pricing-one--pricing">
        <div class="container">
            <div class="sec-title sec-title-animation animation-style1">
                <p class="sec-title__text title-animation">JOB OPENINGS</p>
                <h2 class="sec-title__title title-animation">Explore Our Latest Open Positions</h2>
            </div>
            <div class="row g-4">
                <!--Start Pricing One Single-->
                <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <div class="pricing-one__single">
                            <div class="table-header">
                                <div class="category-box">
                                    <h2><?php echo e($item->title); ?></h2>
                                    <p><?php echo e($item->time); ?></p>
                                </div>

                            </div>

                            <div class="table-content">
                                <ul>
                                    <li>
                                        <p><span class="icon-checked"></span> Salary: <?php echo e($item->salary); ?></p>
                                    </li>
                                    <li>
                                        <p><span class="icon-checked"></span> Vacancy: <?php echo e($item->no_of_vacancy); ?></p>
                                    </li>
                                    <li>
                                        <p><span class="icon-checked"></span> Education: <?php echo e($item->education); ?></p>
                                    </li>
                                </ul>
                            </div>
                            <div class="table-footer">
                                <a class="thm-btn" href="<?php echo e(route('career.show', $item)); ?>">View Detail
                                    <i class="icon-right-arrow"></i>
                                    <span class="hover-btn hover-bx"></span>
                                    <span class="hover-btn hover-bx2"></span>
                                    <span class="hover-btn hover-bx3"></span>
                                    <span class="hover-btn hover-bx4"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <!--End Pricing One Single-->

            </div>
        </div>
    </section>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/frontend/careers/career-index.blade.php ENDPATH**/ ?>