<?php $__env->startSection('title', get_seo_page('faqs')->seo_title ? get_seo_page('faqs')->seo_title : 'FAQs'); ?>

<?php $__env->startSection('headerTitle', 'Frequently asked question'); ?>

<?php $__env->startSection('header'); ?>
    <li class="breadcrumb-item active">FAQs</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('faqs')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_seo_page('faqs')->seo_description ?? get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e(get_seo_page('faqs')->seo_title ?? 'Faqs - ' . get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e(get_seo_page('faqs')->seo_description ?? get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e(get_seo_page('faqs')->seo_title ?? 'Faqs - ' . get_option('title')); ?>">
    <meta name="og:description" content="<?php echo e(get_seo_page('faqs')->seo_description ?? get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('/frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e(get_seo_page('faqs')->seo_title ?? 'Faqs - ' . get_option('title')); ?></h1>
    <section class="faq-one">
        <div class="container">
            <div class="position-relative">
                <div class="title-box">
                    <h3>Frequently Asked Questions</h3>
                    <div class="text">There are many variations of passages of Lorem Ipsum available, but the majority
                        have
                        <br> suffered alteration in some form, by injected humour, or randomised words which
                    </div>
                </div>
                <div class="faq-one_icon">
                    <img src="/frontend/images/icons/faq.png" alt="" />
                </div>
            </div>
            <div class="row g-5 clearfix">

                <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Column -->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <h4><?php echo e($item->title); ?></h4>

                        <!-- Accordion Box -->
                        <ul class="accordion-box style-two">

                            <?php $__currentLoopData = $item->faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <!-- Block -->
                                <li class="accordion block <?php echo e($key == 0 ? 'active-block' : ''); ?>">
                                    <div class="acc-btn <?php echo e($key == 0 ? 'active' : ''); ?>">
                                        <div class="icon-outer">
                                            <span class="icon flaticon-arrow-down"></span>
                                        </div>
                                        <?php echo e($faq->question); ?>

                                    </div>
                                    <div class="acc-content <?php echo e($key == 0 ? 'current' : ''); ?>">
                                        <div class="content">
                                            <p>
                                                <?php echo e($faq->answer); ?>

                                            </p>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </ul>

                    </div>
                    <!-- Column -->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </section>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/faqs/faq-index.blade.php ENDPATH**/ ?>