<?php $__env->startSection('title', $product->seo_title ?? $product->title); ?>

<?php $__env->startSection('headerTitle', $product->title); ?>


<?php $__env->startSection('header'); ?>
    <li> <a href="<?php echo e(route('product.index')); ?>">Products</a> </li>
    <li><span class="icon-right-arrow"></span></li>
    <li class="breadcrumb-item active"><?php echo e($product->title); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e($product->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e($product->seo_description ?? $product->summary); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e($product->seo_title ?? $product->title); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('frontend/images/products/' . $product->image)); ?>">
    <meta name="twitter:description" content="<?php echo e($product->seo_description ?? $product->summary); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e($product->seo_title ?? $product->title); ?>">
    <meta name="og:description" content="<?php echo e($product->seo_description ?? $product->summary); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('frontend/images/products/' . $product->image)); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="/frontend/css/custom.css">
    <style>
        .highlight-one__single-img {
            height: 320px;
        }

        .highlight-one__single-content h2 a {
            font-size: 20px
        }

        .page-header {
            padding: 30px 0px 40px
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e($product->seo_title ?? $product->title); ?></h1>
    <!--Start Product Details-->
    <section class="product-details">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-xl-6">
                    <div class="product-details__left">
                        <div class="product-details__left-inner">
                            <div class="product-details__content-box">
                                <div class="swiper-container" id="shop-details-one__carousel">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <div class="product-details__img">
                                                <img src="<?php echo e($product->imageUrl); ?>" alt="">
                                            </div>
                                        </div><!-- /.swiper-slide -->

                                        <?php if($product->images): ?>
                                            <?php $__currentLoopData = json_decode($product->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="swiper-slide">
                                                    <div class="product-details__img">
                                                        <img src="/frontend/images/products/<?php echo e($item); ?>"
                                                            alt="">
                                                    </div>
                                                </div><!-- /.swiper-slide -->
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                    </div>
                                </div>
                                <div class="product-details__nav">
                                    <div class="swiper-button-prev" id="product-details__swiper-button-next">
                                        <i class="icon-left-arrow"></i>
                                    </div>
                                    <div class="swiper-button-next" id="product-details__swiper-button-prev">
                                        <i class="icon-right-arrow"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="product-details__thumb-box">
                                <div class="swiper-container" id="shop-details-one__thumb">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <div class="product-details__thumb-img">
                                                <img src="<?php echo e($product->imageUrl); ?>" alt="">
                                            </div>
                                        </div><!-- /.swiper-slide -->
                                        <?php if($product->images): ?>
                                            <?php $__currentLoopData = json_decode($product->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="swiper-slide">
                                                    <div class="product-details__thumb-img">
                                                        <img src="/frontend/images/products/<?php echo e($item); ?>"
                                                            alt="">
                                                    </div>
                                                </div><!-- /.swiper-slide -->
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 col-xl-6">
                    <div class="product-details__right">
                        <div class="product-details__top mb-0 ">
                            <h3 class="product-details__title">
                                <?php echo e($product->title); ?>

                            </h3>
                        </div>
                        <div class="product-details__reveiw mt-0 pb-3 pt-0">

                        </div>
                        <div class="product-details__content">
                            <p class="product-details__content-text1">
                                <?php echo e($product->summary); ?>

                            </p>

                        </div>
                        <div class="product-details__inner">

                            <div class="product-details__buttons-boxes">
                                <div class="product-details__buttons-1">
                                    <a href="#" class="thm-btn" data-bs-toggle="modal" data-bs-target="#enquiry">
                                        Enquiry Now
                                        <i class="icon-next"></i>
                                        <span class="hover-btn hover-bx"></span>
                                        <span class="hover-btn hover-bx2"></span>
                                        <span class="hover-btn hover-bx3"></span>
                                        <span class="hover-btn hover-bx4"></span>
                                    </a>
                                </div>

                            </div>
                        </div>
                        <div class="product-details__social">
                            <div class="title">
                                <h3>Share with friends:</h3>
                            </div>
                            <div class="product-details__social-link">
                                <a href="https://facebook.com/sharer/sharer.php?u=<?php echo e(request()->url()); ?>">
                                    <span class="icon-facebook-app-symbol"></span>
                                </a>
                                <a
                                    href="https://twitter.com/intent/tweet?text=<?php echo e($product->title); ?>&url=<?php echo e(request()->url()); ?>">
                                    <span class="icon-twitter-1"></span>
                                </a>
                                <a
                                    href="https://www.linkedin.com/shareArticle?url=<?php echo e(request()->url()); ?>&title=<?php echo e($product->title); ?>">
                                    <span class="icon-linkedin-big-logo"></span>
                                </a>
                                <a
                                    href="https://www.pinterest.com/pin/create/button?url=<?php echo e($product->title); ?>&media=<?php echo e($product->imageUrl); ?>&description=<?php echo e($product->title); ?>">
                                    <span class="icon-pinterest"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--End Product Details-->


    <!--Start Product Description-->
    <section class="product-description">
        <div class="container">
            <div class="product-details__description">
                <div class="product-details__main-tab-box tabs-box">
                    <ul class="tab-buttons clearfix list-unstyled">
                        <li data-tab="#description" class="tab-btn active-btn"><span>Description</span></li>

                        <?php if(json_decode($product->specifications)): ?>
                            <?php $__currentLoopData = json_decode($product->specifications); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li data-tab="#specifications<?php echo e($key); ?>" class="tab-btn">
                                    <span>
                                        <?php echo e($item->title); ?>

                                    </span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </ul>
                    <div class="tabs-content">
                        <!--tab-->
                        <div class="tab active-tab" id="description">
                            <div class="product-details__tab-content-inner">
                                <div class="product-details__description-content">
                                    <?php echo $product->description; ?>

                                </div>
                            </div>
                        </div>
                        <!--tab-->
                        <?php if(json_decode($product->specifications)): ?>
                            <?php $__currentLoopData = json_decode($product->specifications); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="tab " id="specifications<?php echo e($key); ?>">
                                    <div class="product-details__tab-content-inner">
                                        <div class="product__description product-details__additional-information-content">
                                            <?php echo $item->description; ?>

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <!--tab-->

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--End Product Description-->

    <!-- Start Related Products -->
    <section class="related-products">
        <div class="container">
            <div class="related-products__title">
                <h3>Related Products</h3>
                <p>Recommended to Complement Your Choice</p>
            </div>
            <div class="row">

                <div class="related-products__carousel owl-carousel owl-theme owl-dot-style1">
                    <?php $__currentLoopData = get_products_by_category('Product')->except($product->id)->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!--Product All Single Start-->
                        <div class="highlight-one__single">
                            <div class="highlight-one__single-img">
                                <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>">
                            </div>

                            <div class="highlight-one__single-content">
                                <h2>
                                    <a href="<?php echo e(route('product.show', $item)); ?>"><?php echo e($item->title); ?></a>
                                </h2>
                                
                            </div>
                        </div>
                        <!--Product All Single End-->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>
    </section>
    <!-- End Related Products -->

    <style>
        .custom-close-btn {
            border: 1px solid white;
            padding: 10px;
            height: 38px;
            width: 38px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50rem;
            background-color: #ffffffc4;
        }

        .contact-page__form-title {
            font-size: 32px
        }

        .become__a_dealer .thm-btn {
            background: white;
            color: var(--suntop-base)
        }

        .become__a_dealer .thm-btn:hover {
            color: white
        }
    </style>

    <!-- Enquiry-from -->
    <div class="modal fade" id="enquiry">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content contact-page__inner p-0">

                <div class="modal-body p-5">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        <h3 class="contact-page__form-title mb-0">Get A Quote</h3>

                        <button type="button" class="custom-close-btn" data-bs-dismiss="modal" aria-label="Close">
                            <i class="fas fa-times"></i>
                        </button>

                    </div>

                    <form id="contact-form" class=" contact-page__form" action="<?php echo e(route('product.store', $product)); ?>"
                        method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="row">
                            <div class="col-xl-6 col-lg-6">
                                <div class="contact-page__input-box">
                                    <input type="text" name="first_name" value="<?php echo e(old('first_name')); ?>"
                                        placeholder="Your First name" required="" />
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6">
                                <div class="contact-page__input-box">
                                    <input type="text" name="last_name" value="<?php echo e(old('last_name')); ?>"
                                        placeholder="Your Last name" required="" />
                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-6">
                                <div class="contact-page__input-box">
                                    <input type="email" name="email" value="<?php echo e(old('email')); ?>"
                                        placeholder="Your Email" required="" />
                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-6">
                                <div class="contact-page__input-box">
                                    <input type="text" name="phone_number" value="<?php echo e(old('phone_number')); ?>"
                                        placeholder="Phone Number" required="" />
                                </div>
                            </div>

                            <div class="col-xl-12 col-lg-12">
                                <div class="contact-page__input-box">
                                    <input type="text" placeholder="Your Address" value="<?php echo e(old('address')); ?>"
                                        name="address" />
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <div class="contact-page__input-box text-message-box">
                                    <textarea name="remarks" placeholder="If any query"><?php echo e(old('remarks')); ?></textarea>
                                </div>
                            </div>

                            <div class="cta-one__btn become__a_dealer">
                                <button type="submit" class="thm-btn border-0">
                                    Submit
                                    <span class="icon-arrow-up-right"></span>
                                    <span class="hover-btn hover-bx"></span>
                                    <span class="hover-btn hover-bx2"></span>
                                    <span class="hover-btn hover-bx3"></span>
                                    <span class="hover-btn hover-bx4"></span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- /Enquiry-form -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/frontend/products/product-show.blade.php ENDPATH**/ ?>