<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('home')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e(get_seo_page('home')->seo_title ?? get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e(get_seo_page('home')->seo_description ?? get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e(get_seo_page('home')->seo_title ?? get_option('title')); ?>">
    <meta name="og:description" content="<?php echo e(get_seo_page('home')->seo_description ?? get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="/frontend/css/service-compare.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="d-none"><?php echo e(get_seo_page('home')->seo_title ?? get_option('seo_title')); ?></h1>
    <!--Main Slider Start-->
    <section class="main-slider">
        <div class="swiper-container main-slider__carousel">
            <div class="swiper-wrapper">

                <?php $__currentLoopData = get_banners(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide">
                        <div class="main-slider__bg" style="background-image: url(<?php echo e($item->imageUrl); ?>);">
                        </div>
                        <div class="container">
                            <div class="main-slider__content">
                                <h2 class="main-slider__title"><?php echo e($item->title); ?></h2>
                                <h3 class="main-slider__title-two"><?php echo e($item->subtitle); ?> </h3>
                                <p class="main-slider__text"><?php echo $item->summary; ?></p>

                                <?php if($item->button_name): ?>
                                    <div class="main-slider__btn">
                                        <a class="thm-btn" href="<?php echo e($item->button_link); ?>">
                                            <?php echo e($item->button_name); ?>

                                            <i class="icon-right-arrow"></i>
                                            <span class="hover-btn hover-bx"></span>
                                            <span class="hover-btn hover-bx2"></span>
                                            <span class="hover-btn hover-bx3"></span>
                                            <span class="hover-btn hover-bx4"></span>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </div>
            <div class="swiper-pagination" id="main-slider-pagination"></div>
            <!-- If we need navigation buttons -->
        </div>


    </section>
    <!--Main Slider End-->


    <!--Start About One -->
    <?php echo $__env->make('frontend.partials.about-box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--End About One -->

    <!--Start Sliding Text One-->
    <?php echo $__env->make('frontend.partials.sliding-box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--End Sliding Text One-->

    <?php echo $__env->make('frontend.partials.compare-box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--Start Cta One -->
    <?php echo $__env->make('frontend.partials.get-in-touch', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--End Cta One -->

    <!--Start Highlight One -->
    <section class="highlight-one">
        <div class="container">
            <div class="sec-title sec-title-animation animation-style1">

                <h2 class="sec-title__title title-animation">Our Products</h2>
                <p class="sec-title__text title-animation">Quality You Can Trust, Value You Can See</p>
            </div>

            <div class="row">

                <?php $__currentLoopData = get_products_by_category('Product')->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!--Start Highlight One Single-->
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <div class="highlight-one__single">
                            <div class="highlight-one__single-img">
                                <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>">
                            </div>

                            <div class="highlight-one__single-content">
                                <h2>
                                    <a href="<?php echo e(route('product.show', $item)); ?>">
                                        <?php echo e($item->title); ?>

                                    </a>
                                </h2>
                                
                            </div>
                        </div>
                    </div>
                    <!--Start Highlight One Single-->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
            <div class="highlight-one__btn">
                <a class="thm-btn" href="<?php echo e(route('product.index')); ?>">view more product
                    <i class="icon-right-arrow"></i>
                    <span class="hover-btn hover-bx"></span>
                    <span class="hover-btn hover-bx2"></span>
                    <span class="hover-btn hover-bx3"></span>
                    <span class="hover-btn hover-bx4"></span>
                </a>
            </div>
        </div>
    </section>
    <!--End Highlight One -->


    <!--Start Counter One-->
    <section class="counter-one">
        <div class="shape1"><img src="/frontend/images/shapes/counter-v1-shape1.png" alt=""></div>
        <div class="shape2"><img src="/frontend/images/shapes/counter-v1-shape2.png" alt=""></div>
        <div class="container">


            <div class="row">
                <!--Start Counter One Content-->
                <div class="col-xl-8">
                    <div class="counter-one__content">
                        <div class="counter-one__content-title sec-title-animation animation-style1">
                            <h2 class="title-animation">Our Roofing Achievements in <br> Numbers</h2>
                            <p>
                                A quick, data-driven look at our roofing expertise—showcasing the projects we've completed,
                                the clients we’ve served, and the results that reflect our commitment to quality and
                                reliability.
                            </p>
                        </div>
                    </div>
                </div>
                <!--End Counter One Content-->

                <!--Start Counter One Counter-->
                <div class="col-xl-4">
                    <div class="counter-one__counter">
                        <ul class="counter-one__counter-list">
                            <li>
                                <div class="counter-one__counter-text">
                                    <div class="count-box">
                                        <h2 class="count-text text-white" data-stop="1050" data-speed="120">00</h2>
                                        <span class="plus text-white">+</span>
                                    </div>
                                    <p style="color: #ddd">Completed Residential projects</p>
                                </div>
                            </li>

                            <li>
                                <div class="counter-one__counter-text">
                                    <div class="count-box">
                                        <h2 class="count-text text-white" data-stop="650" data-speed="120">00</h2>
                                        <span class="plus text-white">+</span>
                                    </div>
                                    <p style="color: #ddd">Hard working People</p>
                                </div>
                            </li>
                        </ul>

                        <ul class="counter-one__counter-list style2">
                            <li>
                                <div class="counter-one__counter-text">
                                    <div class="count-box">
                                        <h2 class="count-text text-white" data-stop="1250" data-speed="120">00</h2>
                                        <span class="plus percent text-white">+</span>
                                    </div>
                                    <p style="color: #ddd">Completed Commercial projects</p>
                                </div>
                            </li>
                            <li>
                                <div class="counter-one__counter-text">
                                    <div class="count-box">
                                        <h2 class="count-text text-white" data-stop="3659" data-speed="120">00</h2>
                                        <span class="plus text-white">+</span>
                                    </div>
                                    <p style="color: #ddd">Our satisfied clients</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
                <!--End Counter One Counter-->
            </div>
        </div>
    </section>
    <!--End Counter One-->

    <!--Start Testimonial One-->
    <?php echo $__env->make('frontend.partials.testimonial-box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--End Testimonial One-->

    <section class="brand-one">
        <div class="container">
            <div class="brand-one__inner">
                <ul class="brand-one__list clearfix">

                    <?php $__currentLoopData = get_suppliers()->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <div class="img-box">
                                <img src="<?php echo e($item->imageUrl); ?>" class="w-100" alt="<?php echo e($item->title); ?>">
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </ul>
            </div>
        </div>
    </section>
    <!--Start Pricing One-->
    <section class="pricing-one">
        <div class="shape1"><img src="/frontend/images/shapes/pricing-v1-shape1.png" alt=""></div>
        <div class="shape2"><img src="/frontend/images/shapes/pricing-v1-shape2.png" alt=""></div>
        <div class="container">
            <div class="sec-title sec-title-animation animation-style1">

                <h2 class="sec-title__title title-animation">Our Certificate</h2>
                <p class="sec-title__text title-animation" style="color: #ccc">Certified for Reliability & Impact</p>
            </div>
            <div class="certificate-one__carousel owl-carousel owl-theme">
                <!--Start Pricing One Single-->
                <?php $__currentLoopData = get_certificates(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="pricing-one__single wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <img src="<?php echo e($item->imageUrl); ?>" class="w-100 " alt="<?php echo e($item->title); ?>">
                        <div class="table-header border-bottom-0" style="height: calc(100% - 350px)">
                            <div class="category-box border-bottom-0">
                                <h2 class="border-bottom-0"
                                    style="font-size: 20px; height: 48px; overflow: hidden; line-height: 1.2; text-overflow: ellipse">
                                    <?php echo e($item->title); ?></h2>
                            </div>
                        </div>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <!--End Pricing One Single-->
            </div>
        </div>
    </section>
    <!--End Pricing One-->

    <!--Start Blog One-->
    <section class="blog-one">
        <div class="container">
            <div class="sec-title sec-title-animation animation-style1">

                <h2 class="sec-title__title title-animation">Our Latest Blog</h2>
                <p class="sec-title__text title-animation">Fresh Updates From Our Roofing</p>
            </div>
            <div class="blog-one__carousel owl-carousel owl-theme">

                <!--Start Blog One Single-->
                <?php $__currentLoopData = get_recent_blog()->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="blog-one__single wow fadeInUp" data-wow-delay=".3s">
                        <a href="<?php echo e(route('blog.show', $item)); ?>" class="d-block blog-one__single-img">
                            <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>">
                        </a>

                        <div class="blog-one__single-content">
                            <h2>
                                <a href="<?php echo e(route('blog.show', $item)); ?>"><?php echo e($item->title); ?></a>
                            </h2>
                            <p><?php echo e(Str::limit($item->summary, 90)); ?></p>

                            <div class="blog-one__single-content-bottom">
                                <div class="author-info">
                                    <div class="text-box">
                                        <h4><?php echo e($item->category ? $item->category->title : ''); ?></h4>
                                        <p><?php echo e($item->created_at ? $item->created_at->format('d M, Y') : ''); ?></p>
                                    </div>
                                </div>

                                <div class="btn-box">
                                    <a href="<?php echo e(route('blog.show', $item)); ?>">Read More <span
                                            class="icon-right-arrow"></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <!--End Blog One Single-->

            </div>
        </div>
    </section>
    <!--End Blog One-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="/frontend/js/jquery.event.move.js"></script>
    <script src="/frontend/js/jquery.twentytwenty.js"></script>
    <script>
        if ($('.transformation_image').length) {
            $(".transformation_image").twentytwenty({
                no_overlay: true,
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/India/roofing/backend/resources/views/frontend/home/page-index.blade.php ENDPATH**/ ?>