<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e(get_seo_page('home')->seo_keyword ?? get_option('seo_meta_keywords')); ?>">
    <meta name="description" content="<?php echo e(get_option('seo_meta_description')); ?>">
    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e(get_seo_page('home')->seo_title ?? get_option('title')); ?>">
    <meta name="twitter:image" content="<?php echo e(asset('frontend/images/' . get_option('image'))); ?>">
    <meta name="twitter:description"
        content="<?php echo e(get_seo_page('home')->seo_description ?? get_option('seo_meta_description')); ?>">

    <!-- Facebook -->
    <meta property="og:url" content="<?php echo e(request()->url()); ?>">
    <meta property="og:title" content="<?php echo e(get_seo_page('home')->seo_title ?? get_option('title')); ?>">
    <meta name="og:description" content="<?php echo e(get_seo_page('home')->seo_description ?? get_option('seo_meta_description')); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo e(asset('frontend/images/' . get_option('image'))); ?>">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <style>
        .slider-one,
        .slider-one .swiper-container,
        .slider-one .swiper-container .swiper-wrapper {
            height: 650px;
        }

        @media  screen and (max-width: 767px) {

            .slider-one,
            .slider-one .swiper-container,
            .slider-one .swiper-container .swiper-wrapper {
                height: 380px;
            }
        }

        @media  screen and (max-width: 599px) {

            .slider-one,
            .slider-one .swiper-container,
            .slider-one .swiper-container .swiper-wrapper {
                height: 320px;
            }
        }
    </style>
    <h1 class="d-none"><?php echo e(get_seo_page('home')->seo_title ?? get_option('seo_title')); ?></h1>
    <!--Main Slider Start-->
    <!-- Slider One -->
    <section class="slider-one">
        
        <div class="main-slider swiper-container">
            <div class="swiper-wrapper">

                <!-- Slide -->
                <div class="swiper-slide" style="background-image:url(/frontend/images/banners/slider.png)">
                    <div class="container">
                        <div class="row clearfix">

                            <!-- Content Column -->
                            

                            <!-- Image Column -->
                            

                        </div>
                    </div>
                </div>



                <!-- Slide -->
                

                <!-- Slide -->
                

            </div>

            <!-- If we need navigation buttons -->
            <div class="slider-one_arrows">
                <div class="main-slider-prev"><i class="flaticon-left-arrow"></i></div>
                <div class="main-slider-next"><i class="flaticon-next-1"></i></div>
            </div>

            <!-- If we need pagination -->
            

        </div>
    </section>
    <!-- End Main Slider Section -->


    <!--Start About One -->
    <?php echo $__env->make('frontend.partials.about-box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--End About One -->

    <!-- Services One -->
    <section class="services-one">
        <div class="container">
            <div class="row clearfix">

                <!-- Service Block One -->
                <div class="service-block_one col-lg-4 col-md-6 col-sm-6">
                    <div class="service-block_one-inner"
                        style="background-image:url(/frontend/images/background/pattern-1.png)">
                        <div class="service-block_one-upper">
                            <div class="service-block_one-icon flaticon-paint-roll"></div>
                            <h4 class="service-block_one-heading">
                                <a href="#">
                                    Premium Product Range Access
                                </a>
                            </h4>
                        </div>
                        <div class="service-block_one-text">
                            Nepal’s finest collection of sanitary ware, including luxury showers and designer wellness
                            systems.
                        </div>
                    </div>
                </div>

                <!-- Service Block One -->
                <div class="service-block_one col-lg-4 col-md-6 col-sm-6">
                    <div class="service-block_one-inner"
                        style="background-image:url(/frontend/images/background/pattern-1.png)">
                        <div class="service-block_one-upper">
                            <div class="service-block_one-icon flaticon-tiles"></div>
                            <h4 class="service-block_one-heading">
                                <a href="#">Reliable Supply</a>
                            </h4>
                        </div>
                        <div class="service-block_one-text">
                            As a trusted supplier, we ensure high-quality materials and professional support for residential
                            and commercial projects.


                        </div>
                    </div>
                </div>

                <!-- Service Block One -->
                <div class="service-block_one col-lg-4 col-md-6 col-sm-6">
                    <div class="service-block_one-inner"
                        style="background-image:url(/frontend/images/background/pattern-1.png)">
                        <div class="service-block_one-upper">
                            <div class="service-block_one-icon flaticon-punctuality"></div>
                            <h4 class="service-block_one-heading">
                                <a href="#">
                                    Contemporary Finishes
                                </a>
                            </h4>
                        </div>
                        <div class="service-block_one-text">
                            Transform interiors with modern micro-cement and artisanal Moroccan tiles that blend durability
                            with style.
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End Services One -->

    <!-- Cta One -->
    <section class="cta-one">
        <div class="cta-one_bg" style="background-image:url(/frontend/images/banners/slider4.png)"></div>
        <div class="auto-container">
            <div class="row clearfix">

                <!-- CTA One Image -->
                <div class="cta-one_images-column col-lg-4 col-md-4 col-sm-12">
                    <div class="cta-one_images-outer">
                        <div class="cta-one_image">
                            <img src="/frontend/images/resource/cta-1.jpg" alt="" />
                        </div>
                    </div>
                </div>

                <!-- CTA One Content -->
                <div class="cta-one_content-column col-lg-8 col-md-8 col-sm-12">
                    <div class="cta-one_content-outer">
                        <h2 class="cta-one_title text-white">
                            Become a Dealer
                        </h2>
                        <p class="cta-one_title text-white">
                            Partner with us as a dealer and grow your business with a trusted supplier of premium building
                            materials in Nepal, offering high-quality products, reliable support, and long-term growth
                            opportunities.
                        </p>
                        <div class="cta-one_button">
                            <a href="<?php echo e(route('dealer_enquiry.index')); ?>" class="theme-btn btn-style-three">
                                <span class="btn-wrap">
                                    <span class="text-one">Start Now</span>
                                    <span class="text-two">Start Now</span>
                                </span>
                            </a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End Cta One -->

    <!-- Services Two -->
    <section class="services-two">
        <div class="services-two_bg"></div>

        <div class="container">
            <div class="sec-title centered">
                <div class="sec-title_title"><i class="flaticon-wood-1"></i> Products</div>
                <h2 class="sec-title_heading">Best Swimming Pool Products <br> That We Provide</h2>
            </div>
            <div class="row clearfix">

                <?php $__currentLoopData = get_products()->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Service Block Two -->
                    <div class="shop-block_one col-lg-3 col-md-6 col-sm-6">
                        <div class="shop-block_one-inner h-100">
                            <div class="shop-block_one-image">
                                <a href="<?php echo e(route('product.show', $item)); ?>">
                                    <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>" />
                                </a>
                            </div>
                            <div class="shop-block_one-content">
                                <h4 class="shop-block_one-heading">
                                    <a href="<?php echo e(route('product.show', $item)); ?>"><?php echo e($item->title); ?></a>
                                </h4>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



            </div>
        </div>
    </section>
    <!-- End Services Two -->



    <!-- Testimonial One -->
    <section class="testimonial-one">
        <div class="testimonial-one_bg" style="background-image:url(/frontend/images/background/pattern-6.png)">
        </div>
        
        
        <div class="container">
            <div class="sec-title centered">
                <div class="sec-title_title"><i class="flaticon-wood-1"></i> Testimonial</div>
                <h2 class="sec-title_heading">What Does The Customer <br> Have To Say?</h2>
            </div>
            <div class="two-item-carousel swiper-container">
                <div class="swiper-wrapper">

                    <?php $__currentLoopData = get_testimonials(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!-- Slide -->
                        <div class="swiper-slide">
                            <!-- Testimonial Block One -->
                            <div class="testimonial-block_one">
                                <div class="testimonial-block_one-inner">
                                    <div class="testimonial-block_one-color"
                                        style="background-image:url(/frontend/images/background/pattern-7.png)"></div>
                                    <div class="testimonial-block_one-upper">
                                        <div class="testimonial-block_one-author_outer">
                                            <div class="testimonial-block_one-author">
                                                <img src="<?php echo e($item->imageUrl); ?>"
                                                    alt="Testimonial by <?php echo e($item->name); ?>" />
                                            </div>
                                        </div>
                                        <div class="testimonial-block_one-author_content">
                                            <h4><?php echo e($item->name); ?></h4>
                                            <div class="designation"><?php echo e($item->position); ?></div>
                                        </div>
                                        <div class="testimonial-block_one-quote flaticon-left"></div>
                                    </div>
                                    <div class="testimonial-block_one-lower">
                                        <div class="testimonial-block_one-text">
                                            <?php echo e($item->message); ?>

                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>

                <!-- If we need pagination -->
                <div class="two-item-carousel_pagination"></div>

            </div>

        </div>
    </section>
    <!-- End Testimonial One -->
    <!-- Contact One -->
    <section class="contact-one" style="background-image:url(/frontend/images/background/map.png)">
        <div class="container">
            <div>
                <div class="contact-one_image">
                    <img src="/frontend/images/resource/contact.jpg" alt="" />
                    <div class="contact-one_ball" style="background-image:url(/frontend/images/icons/ball.html)">
                    </div>
                </div>
                <div class="contact-one_image-two">
                    <img src="/frontend/images/resource/contact-1.jpg" alt="" />
                </div>
                <div class="row align-items-center clearfix">

                    <!-- Info Column -->
                    <div class="contact-one_info-column col-lg-5 col-md-12 col-sm-12">
                        <div class="contact-one_info-outer">
                            <h2 class="contact-one_title">Feel Free <br> To Contact Us</h2>
                            <ul class="contact-one_list">
                                <li>
                                    <span class="flaticon-telephone"></span>
                                    <strong>Call Anytime</strong>
                                    <?php echo e(get_option('mobile_phone_first')); ?>

                                </li>
                                <li>
                                    <span class="flaticon-pin"></span>
                                    <strong>Address</strong>
                                    <?php echo e(get_option('address')); ?>

                                </li>
                            </ul>
                            <div class="contact-one_phone">
                                <div class="contact-one_phone-inner">
                                    <div class="icon flaticon-comment"></div>
                                    Mail us <br>
                                    <a href="mailto:<?php echo e(get_option('email')); ?>"><span><?php echo e(get_option('email')); ?></span></a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Content Column -->
                    <div class="contact-one_form-column col-lg-7 col-md-12 col-sm-12">
                        <div class="contact-one_form-outer">
                            <div class="title-box">
                                <h3>A Brief Overview Of The Space You Would Like To Decorate. </h3>
                                <div class="text">There are many variations of passages of lorem Ipsum available,
                                    but the majority have suffered alteration in some</div>
                            </div>

                            <!-- Default Form -->
                            <div class="default-form">
                                <form method="post" action="<?php echo e(route('contact.store')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="row clearfix">

                                        <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                            <input type="text" name="username" placeholder="Full Name*"
                                                required="">
                                        </div>

                                        <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                            <input type="text" name="email" placeholder="Email*" required="">
                                        </div>

                                        <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                            <textarea class="" name="message" placeholder="Your Request"></textarea>
                                        </div>

                                        <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                            <!-- Button Box -->
                                            <button type="submit" class="theme-btn submit-btn">
                                                Send Request
                                            </button>
                                        </div>

                                    </div>
                                </form>
                            </div>
                            <!-- End Default Form -->

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <!-- End Contact One -->

    <!-- Blog One -->
    <section class="blog-one">
        <div class="blog-one_bg"></div>
        <div class="container">
            <div class="sec-title centered">
                <div class="sec-title_title"><i class="flaticon-wood-1"></i> Our Blog</div>
                <h2 class="sec-title_heading">Our Latest Blogs <br> & News Post</h2>
            </div>
            <div class="row clearfix">

                <?php $__currentLoopData = get_recent_blog()->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- News Block One -->
                    <div class="news-block_two col-lg-4 col-md-6 col-sm-12">
                        <div class="news-block_two-inner h-100">
                            <div class="news-block_two-image">
                                <a href="<?php echo e(route('blog.show', $item)); ?>">
                                    <img src="<?php echo e($item->imageUrl); ?>" alt="<?php echo e($item->title); ?>" />
                                </a>
                            </div>
                            <div class="news-block_two-content">
                                <div class="news-block_two-title"><?php echo e($item?->category?->title); ?></div>
                                <h5 class="news-block_two-heading">
                                    <a href="<?php echo e(route('blog.show', $item)); ?>">
                                        <?php echo e($item->title); ?>

                                    </a>
                                </h5>
                                <ul class="news-block_two-meta">
                                    <li>
                                        <span class="icon fa fa-user"></span>By Admin
                                    </li>
                                    <li>
                                        <span class="icon fa fa-calendar"></span>
                                        <?php echo e($item?->created_at?->format('d M, Y')); ?>

                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </div>
        </div>
    </section>
    <!-- End Blog One -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/infinity/nepal/Europa/backend/resources/views/frontend/home/page-index.blade.php ENDPATH**/ ?>