<?php

use Illuminate\Support\Facades\Route;

// Home Page
Route::get('/', [App\Http\Controllers\Frontend\Home\FrontendController::class, 'index'])->name('page.index');

Route::get('/contacts', [App\Http\Controllers\Frontend\Contact\ContactController::class, 'index'])->name('contact.index');
Route::post('/contacts', [App\Http\Controllers\Frontend\Contact\ContactController::class, 'store'])->name('contact.store');

// Subscriber
Route::post('/customer_enquiry', [App\Http\Controllers\Frontend\Customer\EnquiryController::class, 'store'])->name('customer_enquiry.store');

// Faq
Route::get('faqs', [App\Http\Controllers\Frontend\Faq\FaqController::class, 'index'])->name('faq.index');
Route::post('faqs', [App\Http\Controllers\Frontend\Faq\FaqController::class, 'store'])->name('faq.store');

// Location
Route::get('location', [App\Http\Controllers\Frontend\Location\LocationController::class, 'index'])->name('location.index');

// Product
Route::get('products', [App\Http\Controllers\Frontend\Product\ProductController::class, 'index'])->name('product.index');
Route::get('products', [App\Http\Controllers\Frontend\Product\ProductController::class, 'index'])->name('product.index');
Route::get('products/{product}', [App\Http\Controllers\Frontend\Product\ProductController::class, 'show'])->name('product.show');
Route::post('products/{product}', [App\Http\Controllers\Frontend\Product\RequestController::class, 'store'])->name('product.store');

// Product by category
Route::get('/category/{category}', [App\Http\Controllers\Frontend\Category\CategoryController::class, 'show'])->name('category.show');

// About Us
Route::get('about-us', [App\Http\Controllers\Frontend\About\AboutController::class, 'index'])->name('about.index');

// Catalogue
Route::get('events', [App\Http\Controllers\Frontend\Event\EventController::class, 'index'])->name('event.index');
Route::get('events/{event}', [App\Http\Controllers\Frontend\Event\EventController::class, 'show'])->name('event.show');

// Terms & Condition
Route::get('terms-and-condition', [App\Http\Controllers\Frontend\Page\TermConditionController::class, 'index'])->name('term.index');

// Dealer Policies
Route::get('dealer-policy', [App\Http\Controllers\Frontend\Page\DealerController::class, 'index'])->name('dealer.index');

// Privacy Policy
Route::get('privacy-policy', [App\Http\Controllers\Frontend\Page\PrivacyController::class, 'index'])->name('privacy.index');

// Blog & Events
Route::get('blogs', [App\Http\Controllers\Frontend\Blog\BlogController::class, 'index'])->name('blog.index');
Route::get('blogs/{blog}', [App\Http\Controllers\Frontend\Blog\BlogController::class, 'show'])->name('blog.show');
Route::get('blogs/category/{blog_category}', [App\Http\Controllers\Frontend\Blog\CategoryController::class, 'show'])->name('blog_category.show');

// Career
Route::get('careers', [App\Http\Controllers\Frontend\Career\CareerController::class, 'index'])->name('career.index');
Route::get('careers/{joblist}', [App\Http\Controllers\Frontend\Career\CareerController::class, 'show'])->name('career.show');
Route::get('careers/{joblist}/apply', [App\Http\Controllers\Frontend\Career\CareerController::class, 'apply'])->name('career.apply');
Route::post('careers/{joblist}/apply', [App\Http\Controllers\Frontend\Career\CareerController::class, 'store'])->name('career.store');

// Dealer Enquiry
Route::get('become-a-dealer', [App\Http\Controllers\Frontend\Dealer\EnquiryController::class, 'index'])->name('dealer_enquiry.index');
Route::post('become-a-dealer', [App\Http\Controllers\Frontend\Dealer\EnquiryController::class, 'store'])->name('dealer_enquiry.store');

// Videos
Route::get('videos', [App\Http\Controllers\Frontend\Video\VideoController::class, 'index'])->name('video.index');

// gallery
Route::get('galleries', [App\Http\Controllers\Frontend\Gallery\GalleryController::class, 'index'])->name('gallery.index');


// Auth
Route::get('login', [App\Http\Controllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
Route::post('login', [App\Http\Controllers\Auth\LoginController::class, 'login']);

Route::post('logout', [App\Http\Controllers\Auth\LogoutController::class, 'logout'])->name('logout');
Route::post('password/confirm', [App\Http\Controllers\Auth\ConfirmPasswordController::class, 'confirm']);
Route::post('password/email', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');

Route::get('password/reset', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('password/reset', [App\Http\Controllers\Auth\ResetPasswordController::class, 'reset'])->name('password.update');

Route::get('password/reset/{token}', [App\Http\Controllers\Auth\ResetPasswordController::class, 'showResetForm'])->name('password.reset');


Route::group(['prefix' => 'dashboard', 'middleware' => ['auth', 'web']], function () {
    Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');

    // End User
    // Change Password && Update Profile Detail
    Route::get('/change-password', [App\Http\Controllers\Backend\Profile\ProfileController::class, 'password'])->name('changepassword.index');

    // Notification
    Route::get('my-notifications', [App\Http\Controllers\Customer\Notification\NotificationController::class, 'index'])->name('my-notifications.index');

    // Profile
    Route::get('/profile', [App\Http\Controllers\Backend\Profile\ProfileController::class, 'index'])->name('profile.index');
    Route::get('profile/update', [App\Http\Controllers\Backend\Profile\ProfileController::class, 'edit'])->name('profile.edit');
    Route::post('/profile/change', [App\Http\Controllers\Backend\Profile\ProfileController::class, 'update'])->name('profile.update');
    Route::post('/profile/password/change', [App\Http\Controllers\Backend\Profile\ProfileController::class, 'profile_update'])->name('password.change');

    //route for roles
    Route::prefix('roles')->group(function() {
        Route::get('/', [App\Http\Controllers\Backend\User\RoleController::class, 'index'])->name('roles.index');
        Route::get('edit/{role}', [App\Http\Controllers\Backend\User\RoleController::class, 'edit'])->name('roles.edit');
        Route::get('create', [App\Http\Controllers\Backend\User\RoleController::class, 'create'])->name('roles.create');
        Route::post('store', [App\Http\Controllers\Backend\User\RoleController::class, 'store'])->name('roles.store');
        Route::put('update/{role}', [App\Http\Controllers\Backend\User\RoleController::class, 'update'])->name('roles.update');
        Route::get('delete/{role}', [App\Http\Controllers\Backend\User\RoleController::class, 'destroy'])->name('roles.destroy');
    });

    Route::prefix('users')->group(function(){
        Route::get('/', [App\Http\Controllers\Backend\User\UserController::class, 'index'])->name('users.index');
        Route::get('create', [App\Http\Controllers\Backend\User\UserController::class, 'create'])->name('users.create');
        Route::get('edit/{user}', [App\Http\Controllers\Backend\User\UserController::class, 'edit'])->name('users.edit');
        Route::post('store', [App\Http\Controllers\Backend\User\UserController::class, 'store'])->name('users.store');
        Route::put('update/{user}', [App\Http\Controllers\Backend\User\UserController::class, 'update'])->name('users.update');;
        Route::delete('delete/{user}', [App\Http\Controllers\Backend\User\UserController::class, 'destroy'])->name('users.destroy');;
        Route::get('show/{user}', [App\Http\Controllers\Backend\User\UserController::class, 'show'])->name('users.show');
    });


    // Brand
    Route::resource('brands', App\Http\Controllers\Backend\Brand\BrandController::class);
    Route::post('brands/quickedit/{brand}', [App\Http\Controllers\Backend\Brand\BrandController::class, 'status']);

    // Category
    Route::resource('categories', App\Http\Controllers\Backend\Category\CategoryController::class);
    Route::post('groups/categories', [App\Http\Controllers\Backend\Category\CategoryController::class, 'category']);
    Route::post('categories/getCategory', [App\Http\Controllers\Backend\Category\CategoryController::class, 'get_category']);
    Route::post('categories/quickedit/{category}', [App\Http\Controllers\Backend\Category\CategoryController::class, 'status']);
    Route::post('categories/status/{category}', [App\Http\Controllers\Backend\Category\CategoryController::class, 'home']);

    // User Management
    Route::resource('teams', App\Http\Controllers\Backend\User\TeamController::class);
    Route::resource('endusers', App\Http\Controllers\Backend\User\UserController::class);

    Route::resource('customer_enquiries', App\Http\Controllers\Backend\Customer\EnquiryController::class);

    // Product
    // Product Route
    Route::prefix('products')->group(function(){
    	Route::get('/', [App\Http\Controllers\Backend\Product\ProductController::class, 'index'])->name('products.index');
    	Route::get('create', [App\Http\Controllers\Backend\Product\ProductController::class, 'create'])->name('products.create');
    	Route::get('edit/{product}', [App\Http\Controllers\Backend\Product\ProductController::class, 'edit'])->name('products.edit');
    	Route::post('store', [App\Http\Controllers\Backend\Product\ProductController::class, 'store'])->name('products.store');
    	Route::put('update/{product}', [App\Http\Controllers\Backend\Product\ProductController::class, 'update'])->name('products.update');
    	Route::delete('delete/{product}', [App\Http\Controllers\Backend\Product\ProductController::class, 'destroy'])->name('products.destroy');
    	Route::get('show/{product}', [App\Http\Controllers\Backend\Product\ProductController::class, 'show'])->name('products.show');

        Route::post('/quickedit/{product}', [App\Http\Controllers\Backend\Product\ProductController::class, 'status']);

    	//routes for import and export of product
    	Route::get('import-view', [App\Http\Controllers\Backend\Product\ImportExportController::class, 'index'])->name('products.import');
    	Route::post('import', [App\Http\Controllers\Backend\Product\ImportExportController::class, 'import']);
    	Route::get('export',[App\Http\Controllers\Backend\Product\ImportExportController::class, 'export'])->name('products.export');

    });

    // Product Request
    Route::resource('product_requests', App\Http\Controllers\Backend\Product\RequestController::class)->only(['index', 'show', 'destroy']);

    // Type
    Route::resource('certificates', App\Http\Controllers\Backend\Certificate\CertificateController::class);
    Route::post('certificates/quickedit/{certificate}', [App\Http\Controllers\Backend\Certificate\CertificateController::class, 'status']);

    // PageController
    Route::resource('pages', App\Http\Controllers\Backend\Page\PageController::class);

    // Notification
    Route::resource('notifications', App\Http\Controllers\Backend\Notification\NotificationController::class);

    // Catalogue
    Route::resource('locations', App\Http\Controllers\Backend\Location\LocationController::class);
    Route::post('locations/quickedit/{location}', [App\Http\Controllers\Backend\Location\LocationController::class, 'status']);

    Route::resource('plugins', App\Http\Controllers\Backend\Plugin\PluginController::class);
    Route::post('plugins/quickedit/{plugin}', [App\Http\Controllers\Backend\Plugin\PluginController::class, 'status']);

    // Testimonial
    Route::resource('testimonials', App\Http\Controllers\Backend\Testimonial\TestimonialController::class);
    Route::post('testimonials/quickedit/{testimonial}', [App\Http\Controllers\Backend\Testimonial\TestimonialController::class, 'status']);

    // Frontend Form
    Route::resource('subscribers', App\Http\Controllers\Backend\Subscriber\SubscriberController::class);
    Route::resource('contact_forms', App\Http\Controllers\Backend\Contact\ContactController::class);

    // Career Manage
    Route::resource('joblists', App\Http\Controllers\Backend\Job\JoblistController::class);
    Route::resource('candidates', App\Http\Controllers\Backend\Job\CandidateController::class);

    // Content Manage
    // Blog Content
    Route::resource('blogs', App\Http\Controllers\Backend\Blog\BlogController::class);
    Route::post('blogs/quickedit/{blog}', [App\Http\Controllers\Backend\Blog\BlogController::class, 'status']);

    Route::resource('blog_categories', App\Http\Controllers\Backend\Blog\CategoryController::class);
    Route::post('blog_categories/quickedit/{blog_category}', [App\Http\Controllers\Backend\Blog\CategoryController::class, 'status']);

    // FAQs Content
    Route::resource('faqs', App\Http\Controllers\Backend\Faq\FaqController::class);
    Route::post('faqs/quickedit/{faq}', [App\Http\Controllers\Backend\Faq\FaqController::class, 'status']);

    Route::resource('faq_types', App\Http\Controllers\Backend\Faq\TypeController::class);
    Route::post('faq_types/quickedit/{faq_type}', [App\Http\Controllers\Backend\Faq\TypeController::class, 'status']);

    Route::resource('faq_requests', App\Http\Controllers\Backend\Faq\RequestController::class);

    // Dealer Request
    Route::resource('dealer_requests', App\Http\Controllers\Backend\Dealer\DealerRequestController::class)->only(['index', 'show', 'destroy']);
    Route::resource('dealer_enquiries', App\Http\Controllers\Backend\Dealer\EnquiryController::class)->only(['index', 'show', 'destroy']);

    Route::resource('events', App\Http\Controllers\Backend\Event\EventController::class);
    Route::post('events/quickedit/{event}', [App\Http\Controllers\Backend\Event\EventController::class, 'status']);


    // Seo Page
    Route::resource('page_seos', App\Http\Controllers\Backend\Page\SeoController::class);

    // Administration
    Route::get('administration/backup_database', [App\Http\Controllers\Backend\Utility\UtilityController::class, 'backup_database'])->name('utility.backup_database');

    // Slider
    Route::resource('sliders', App\Http\Controllers\Backend\Slider\SliderController::class);
    Route::post('sliders/quickedit/{slider}', [App\Http\Controllers\Backend\Slider\SliderController::class, 'status']);

    // Gallery
    Route::resource('galleries', App\Http\Controllers\Backend\Gallery\GalleryController::class);
    Route::post('galleries/quickedit/{gallery}', [App\Http\Controllers\Backend\Gallery\GalleryController::class, 'status']);

    // Gallery
    Route::resource('videos', App\Http\Controllers\Backend\Video\VideoController::class);
    Route::post('videos/quickedit/{video}', [App\Http\Controllers\Backend\Video\VideoController::class, 'status']);

    // Gallery
    Route::resource('suppliers', App\Http\Controllers\Backend\Supplier\SupplierController::class);
    Route::post('suppliers/quickedit/{supplier}', [App\Http\Controllers\Backend\Supplier\SupplierController::class, 'status']);

    // General Setting
    Route::get('administration/general/settings', [App\Http\Controllers\Backend\Setting\SettingController::class, 'index'])->name('general.settings');
    Route::post('administration/office/store', [App\Http\Controllers\Backend\Setting\SettingController::class, 'office_store'])->name('office.store');
    Route::post('administration/social/store', [App\Http\Controllers\Backend\Setting\SettingController::class, 'social_store'])->name('socials.store');
    Route::post('administration/logo/update', [App\Http\Controllers\Backend\Setting\SettingController::class, 'qr_code'])->name('settings.qr_code');
    Route::post('administration/meta/update', [App\Http\Controllers\Backend\Setting\SettingController::class, 'meta'])->name('settings.metaUpdate');

    Route::post('administration/notification', [App\Http\Controllers\Backend\Setting\SettingController::class, 'notification'])->name('notification.setting');

});
