<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Product
Route::get('products/{category}', [App\Http\Controllers\Frontend\Category\CategoryController::class, 'index']);
Route::get('products/{category}/filter', [App\Http\Controllers\Frontend\Category\FilterController::class, 'index'])->name('categoryApi');

// Search
Route::get('searches', [App\Http\Controllers\Frontend\Search\SearchController::class, 'show']);
Route::get('searches/filters', [App\Http\Controllers\Frontend\Search\FilterController::class, 'index']);

// Category
Route::get('categories', [App\Http\Controllers\Api\Frontend\Category\CategoryController::class, 'index']);
Route::post('categories/filter', [App\Http\Controllers\Api\Frontend\Category\FilterController::class, 'index']);
Route::get('shops', [App\Http\Controllers\Api\Frontend\Shop\ShopController::class, 'index']);
