@extends('layouts.frontend.main')

@php
    $pagename = $products->count() . ' products has been found on ' . $search;
@endphp

@section('title', $pagename)

@section('title', $products->count() . ' has been found in ' . $search)

@section('header')
    <li><a href="{{ route('product.index') }}">Products</a></li>
    <li><span class="icon-angle-right"></span></li>
    <li class="breadcrumb-item active">{{ $pagename }}</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ $products->count() . ' has been found in ' . $search }}">
    <meta name="twitter:image" content="{{ asset('assets/images/resources/' . get_option('image')) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ $products->count() . ' has been found in ' . $search }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('assets/images/resources/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('styles')
    <link rel="stylesheet" href="/assets/css/module-css/shop.css" />

    <style>
        .hidden {
            display: none !important;
        }

        /* Responsive */
        .mobile__filter {
            display: none;
        }

        @media screen and (max-width: 1200px) {
            .mobile__filter {
                display: block;
                /* width: 100%; */
            }

            .desktop__filter {
                display: none;
            }
        }

        /* Filter */
        .category__list {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-orient: horizontal;
            -webkit-box-direction: normal;
            -ms-flex-flow: row wrap;
            flex-flow: row wrap;
            -webkit-box-align: baseline;
            -ms-flex-align: baseline;
            align-items: baseline;
            margin: 0;
            padding-left: 17px !important;
            grid-gap: 10px;
            padding-bottom: 20px;
            /* margin-bottom: 15px; */
            /* border-bottom: 1px solid #d4d5d9; */
        }

        .category__list li {
            list-style: none;
        }

        .category__item {
            position: relative;
            background-color: #fff;
            text-transform: capitalize;
            color: #3e4152;
            cursor: default;
            font-size: 14px;
            padding: 6px 36px 5px 20px;
            -webkit-transition: all 0.2s ease-out;
            transition: all 0.2s ease-out;
            border-radius: 20px;
            border: 1px solid #d4d5d9;
        }

        .filter-summary-removeFilter {
            position: absolute;
            top: 4px;
            right: 4px;
            width: 18px;
            height: 20px;
            z-index: 1;
            text-align: center;
            cursor: pointer;
            right: 10px;
            top: 6px;
            margin: 0;
        }

        .filter-summary-removeIcon {
            vertical-align: middle;
            opacity: 0.7;
            -webkit-transform: scale(0.7);
            transform: scale(0.7);
        }

        .store__widget .offcanvas-header {
            background-color: var(--crank-base);
        }

        .store__widget .offcanvas-header .h5 {
            margin-bottom: 0;
            color: white;
        }

        .store__widget .btn-close {
            background: transparent var(--bs-btn-close-bg) center/1em auto no-repeat;
            background-color: white;
        }
    </style>
@endsection

@section('content')
    <div id="searchFilterContainer" data-slug="{{ $search }}"></div>
@endsection

@section('scripts')
    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const btn = document.getElementById("filter-toggle");
            const sidebar = document.getElementById("filter-sidebar");
            const productsCol = document.getElementById("products-col");

            btn.addEventListener("click", () => {
                sidebar.classList.toggle("hidden");

                // adjust product column width dynamically
                if (sidebar.classList.contains("hidden")) {
                    productsCol.classList.remove("col-xl-9", "col-lg-8");
                    productsCol.classList.add("col-12");
                } else {
                    productsCol.classList.remove("col-12");
                    productsCol.classList.add("col-xl-9", "col-lg-8");
                }
            });
        });
    </script>
@endsection
