@extends('layouts.frontend.main')

@section('title', 'Privacy Policy')

@section('headerTitle', 'Privacy Policy')

@section('header')
    <li class="breadcrumb-item active">Privacy Policy</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ $page->seo_keyword ?? get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ $page->seo_description ?? get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ $page->seo_title ?? 'Privacy Policy - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description" content="{{ $page->seo_description ?? get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ $page->seo_title ?? 'Privacy Policy - ' . get_option('title') }}">
    <meta name="og:description" content="{{ $page->seo_description ?? get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('styles')
    <link rel="stylesheet" href="/frontend/css/custom.css">
@endsection

@section('content')
    <h1 class="d-none">{{ $page->seo_title ?? 'Privacy Policy - ' . get_option('title') }}</h1>
    <div class="sidebar-page-container">
        <div class="container">
            <div class="row clearfix">
                @include('frontend.partials.policy-sidebar')

                <!-- Content Side -->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <div class="blog-detail">
                        <div class="blog-detail_inner">
                            <div class="blog-detail_image">
                                <div class="blog-detail_content">
                                    <ul class="blog-detail_meta">
                                        <li>
                                            <span class="icon fa fa-user"></span>By Admin
                                        </li>
                                        <li>
                                            <span class="icon fa fa-calendar"></span>
                                            Updated on {{ $page?->created_at?->format('d M, Y') }}
                                        </li>
                                    </ul>
                                    <h3 class="blog-detail_heading">{{ $page->title }}</h3>
                                    <div class="blog-detail-description">
                                        {!! $page->description !!}
                                    </div>


                                    <!-- Post Share Options-->


                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <!-- Sidebar Side -->


            </div>
        </div>
    </div>


@endsection
