@extends('layouts.frontend.main')

@section('headerTitle', 'Gallery')

@section('title', get_seo_page('gallery')->seo_title ?? 'Gallery')

@section('meta')
    <meta name="keywords" content="{{ get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ get_seo_page('gallery')->seo_title ?? 'Gallery - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ get_seo_page('gallery')->seo_title ?? 'Gallery - ' . get_option('title') }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('header')
    <li class="breadcrumb-item active">Gallery</li>
@endsection

@section('styles')
    <style>
        .team-one__content {
            margin-left: 0;
            margin-right: 0
        }
    </style>
@endsection


@section('content')
    <section class="team-one">
        <div class="container">
            <div class="row">

                <div class="col-xl-12 mb-4">
                    <div class="about-one__content-title sec-title-animation animation-style2">
                        <h2 class="title-animation">Nataraj Roofing Tour</h2>
                    </div>
                </div>
                <!--Start Team One Single-->
                <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                    <div class="team-one__single">
                        <div class="team-one__img-box">
                            <a class="team-one__img html5lightbox" href="/frontend/images/galleries/01.jpg"
                                data-showdownloadbutton="true" data-group="mygroup"
                                data-thumbnail="/frontend/images/galleries/01.jpg" data-title="Nataraj Roofing Pvt Ltd">
                                <img src="/frontend/images/galleries/01.jpg" />
                            </a>
                        </div>
                        <div class="team-one__content">
                            <h3 class="team-one__title" style="line-height: 1.1; ">
                                <a href="#" class="fs-5" style="font-weight: 500; line-height: 1.1; ">
                                    Download
                                </a>
                            </h3>
                        </div>
                    </div>
                </div>
                <!--End Team Two Single-->

                <!--Start Team One Single-->
                <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                    <div class="team-one__single">
                        <div class="team-one__img-box">
                            <a class="team-one__img html5lightbox" href="/frontend/images/galleries/02.jpg"
                                data-showdownloadbutton="true" data-group="mygroup"
                                data-thumbnail="/frontend/images/galleries/02.jpg" data-title="Nataraj Roofing Pvt Ltd">
                                <img src="/frontend/images/galleries/02.jpg" />
                            </a>
                        </div>
                        <div class="team-one__content">
                            <h3 class="team-one__title" style="line-height: 1.1; ">
                                <a href="#" class="fs-5" style="font-weight: 500; line-height: 1.1; ">
                                    Download
                                </a>
                            </h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                    <div class="team-one__single">
                        <div class="team-one__img-box">
                            <a class="team-one__img html5lightbox" href="/frontend/images/galleries/04.jpg"
                                data-showdownloadbutton="true" data-group="mygroup"
                                data-thumbnail="/frontend/images/galleries/04.jpg" data-title="Nataraj Roofing Pvt Ltd">
                                <img src="/frontend/images/galleries/03.jpg" />
                            </a>
                        </div>
                        <div class="team-one__content">
                            <h3 class="team-one__title" style="line-height: 1.1; ">
                                <a href="#" class="fs-5" style="font-weight: 500; line-height: 1.1; ">
                                    Download
                                </a>
                            </h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                    <div class="team-one__single">
                        <div class="team-one__img-box">
                            <a class="team-one__img html5lightbox" href="/frontend/images/galleries/04.jpg"
                                data-showdownloadbutton="true" data-group="mygroup"
                                data-thumbnail="/frontend/images/galleries/04.jpg" data-title="Nataraj Roofing Pvt Ltd">
                                <img src="/frontend/images/galleries/04.jpg" />
                            </a>
                        </div>
                        <div class="team-one__content">
                            <h3 class="team-one__title" style="line-height: 1.1; ">
                                <a href="#" class="fs-5" style="font-weight: 500; line-height: 1.1; ">
                                    Download
                                </a>
                            </h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                    <div class="team-one__single">
                        <div class="team-one__img-box">
                            <a class="team-one__img html5lightbox" href="/frontend/images/galleries/05.jpg"
                                data-showdownloadbutton="true" data-group="mygroup"
                                data-thumbnail="/frontend/images/galleries/05.jpg" data-title="Nataraj Roofing Pvt Ltd">
                                <img src="/frontend/images/galleries/05.jpg" />
                            </a>
                        </div>
                        <div class="team-one__content">
                            <h3 class="team-one__title" style="line-height: 1.1; ">
                                <a href="#" class="fs-5" style="font-weight: 500; line-height: 1.1; ">
                                    Download
                                </a>
                            </h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                    <div class="team-one__single">
                        <div class="team-one__img-box">
                            <a class="team-one__img html5lightbox" href="/frontend/images/galleries/06.jpg"
                                data-showdownloadbutton="true" data-group="mygroup"
                                data-thumbnail="/frontend/images/galleries/06.jpg" data-title="Nataraj Roofing Pvt Ltd">
                                <img src="/frontend/images/galleries/06.jpg" />
                            </a>
                        </div>
                        <div class="team-one__content">
                            <h3 class="team-one__title" style="line-height: 1.1; ">
                                <a href="#" class="fs-5" style="font-weight: 500; line-height: 1.1; ">
                                    Download
                                </a>
                            </h3>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
@endsection

@section('scripts')
    <script src="/html5lightbox/html5lightbox.js"></script>
@endsection
