@extends('layouts.frontend.main')

@section('title', get_seo_page('faqs')->seo_title ? get_seo_page('faqs')->seo_title : 'FAQs')

@section('headerTitle', 'Frequently asked question')

@section('header')
    <li class="breadcrumb-item active">FAQs</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ get_seo_page('faqs')->seo_keyword ?? get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_seo_page('faqs')->seo_description ?? get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ get_seo_page('faqs')->seo_title ?? 'Faqs - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description"
        content="{{ get_seo_page('faqs')->seo_description ?? get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ get_seo_page('faqs')->seo_title ?? 'Faqs - ' . get_option('title') }}">
    <meta name="og:description" content="{{ get_seo_page('faqs')->seo_description ?? get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection


@section('content')
    <h1 class="d-none">{{ get_seo_page('faqs')->seo_title ?? 'Faqs - ' . get_option('title') }}</h1>
    <section class="faq-one">
        <div class="container">
            <div class="position-relative">
                <div class="title-box">
                    <h3>Frequently Asked Questions</h3>
                    <div class="text">There are many variations of passages of Lorem Ipsum available, but the majority
                        have
                        <br> suffered alteration in some form, by injected humour, or randomised words which
                    </div>
                </div>
                <div class="faq-one_icon">
                    <img src="/frontend/images/icons/faq.png" alt="" />
                </div>
            </div>
            <div class="row g-5 clearfix">

                @foreach ($faqs as $index => $item)
                    <!-- Column -->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <h4>{{ $item->title }}</h4>

                        <!-- Accordion Box -->
                        <ul class="accordion-box style-two">

                            @foreach ($item->faqs as $key => $faq)
                                <!-- Block -->
                                <li class="accordion block {{ $key == 0 ? 'active-block' : '' }}">
                                    <div class="acc-btn {{ $key == 0 ? 'active' : '' }}">
                                        <div class="icon-outer">
                                            <span class="icon flaticon-arrow-down"></span>
                                        </div>
                                        {{ $faq->question }}
                                    </div>
                                    <div class="acc-content {{ $key == 0 ? 'current' : '' }}">
                                        <div class="content">
                                            <p>
                                                {{ $faq->answer }}
                                            </p>
                                        </div>
                                    </div>
                                </li>
                            @endforeach


                        </ul>

                    </div>
                    <!-- Column -->
                @endforeach

            </div>
        </div>
    </section>



@endsection
