@extends('layouts.frontend.main')

@section('title', get_seo_page('contact-us')->seo_title ?? 'Contact Us')

@section('headerTitle', 'Contact Us')

@section('header')
    <li class="breadcrumb-item active">Contact Us</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ get_seo_page('contact-us')->seo_keyword ?? get_option('seo_meta_keywords') }}">
    <meta name="description"
        content="{{ get_seo_page('contact-us')->seo_description ?? get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title"
        content="{{ get_seo_page('contact-us')->seo_title ?? 'Contact Us - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description"
        content="{{ get_seo_page('contact-us')->seo_description ?? get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title"
        content="{{ get_seo_page('contact-us')->seo_title ?? 'Contact Us - ' . get_option('title') }}">
    <meta name="og:description"
        content="{{ get_seo_page('contact-us')->seo_description ?? get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('/frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection



@section('content')
    <h1 class="d-none">{{ get_seo_page('contact-us')->seo_title ?? 'Contact Us' . get_option('title') }}</h1>
    <!--Contact Info Start-->

    <!-- Map One -->
    <section class="map-one">
        <div class="container">
            <div class="row clearfix">

                <!-- Info Column -->
                <div class="info-column col-lg-5 col-md-12 col-sm-12">
                    <div class="info-column_inner">
                        <h3 class="map-one_title">Please Don't Hesitate To Contact Us </h3>
                        <div class="map-one_text">You can also reach out to us by phone or email</div>
                        <ul class="map-one_info">
                            <li>
                                <span class="icon flaticon-map"></span>
                                <strong>Address</strong>
                                {{ get_option('address') }}
                            </li>
                            <li>
                                <span class="icon flaticon-telephone-1"></span>
                                <strong>Contact</strong>
                                <a href="tel:{{ get_option('mobile_phone_first') }}">
                                    {{ get_option('mobile_phone_first') }}
                                </a>
                                <br>
                                <a href="mailto:{{ get_option('email') }}">
                                    <span>{{ get_option('email') }}</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Team Block One -->
                <div class="map-column col-lg-7 col-md-12 col-sm-12">
                    <div class="map-column_inner">
                        <iframe src="{{ get_option('google_map') }}" allowfullscreen=""></iframe>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End Map One -->

    <!-- Contact Two -->
    <section class="contact-two" style="background-image:url(/frontend/images/background/26.jpg)">
        <div class="container">
            <div class="row align-items-center clearfix">

                <!-- Form Column -->
                <div class="contact-two_form-column col-lg-6 col-md-12 col-sm-12">
                    <div class="contact-two-form_outer">
                        <!-- Contact Form -->
                        <div class="contact-form">
                            <form method="post" action="{{ route('contact.store') }}" id="contact-form">
                                @csrf
                                <div class="row clearfix">

                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <label>First Name</label>
                                        <input type="text" name="first_name" value="{{ old('first_name') }}"
                                            placeholder="First Name" required="">
                                    </div>

                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <label>Last Name</label>
                                        <input type="text" name="last_name" value="{{ old('last_name') }}"
                                            placeholder="Last Name" required="">
                                    </div>

                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <label>Phone No.</label>
                                        <input type="text" name="phone_number" value="{{ old('phone_number') }}"
                                            placeholder="Your Phone" required="">
                                    </div>

                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <label>Email</label>
                                        <input type="text" name="email" value="{{ old('email') }}"
                                            placeholder="Your Email" required="">
                                    </div>

                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <label>Subject</label>
                                        <input type="text" name="subject" value="{{ old('subject') }}"
                                            placeholder="Subject" required="">
                                    </div>

                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <label>Message</label>
                                        <textarea class="" name="message" placeholder="Your Request">{{ old('message') }}</textarea>
                                    </div>

                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <!-- Button Box -->
                                        <button type="submit" class="theme-btn btn-style-one">
                                            <span class="btn-wrap">
                                                <span class="text-one">Send Message</span>
                                                <span class="text-two">Send Message</span>
                                            </span>
                                        </button>
                                    </div>

                                </div>
                            </form>
                        </div>
                        <!-- End Contact Form -->
                    </div>
                </div>

                <!-- Team Block One -->
                <div class="contact-two_title-column col-lg-6 col-md-12 col-sm-12">
                    <div class="contact-two_title-outer">
                        <h3 class="contact-two_title">To Speak To Our Friendly Team, Please Contact</h3>
                        <div class="contact-two_text">Drop us a line and we will ensure the appropriate team responds to
                            your enquiry.</div>
                        <div class="contact-two_support">
                            <img src="/frontend/images/abouts/about-image-1.png" alt="" />
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End Contact Two -->




@endsection
