@extends('layouts.frontend.main')


@section('title', get_seo_page('career')->seo_title ?? 'Our Career')

@section('headerTitle', 'Our Career')

@section('header')
    <li class="breadcrumb-item active">Our Career</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ get_seo_page('career')->seo_keyword ?? get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_seo_page('career')->seo_description ?? get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ get_seo_page('career')->seo_title ?? 'Career - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description"
        content="{{ get_seo_page('career')->seo_description ?? get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ get_seo_page('career')->seo_title ?? 'Career - ' . get_option('title') }}">
    <meta name="og:description"
        content="{{ get_seo_page('career')->seo_description ?? get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('styles')
    <style>
        .pricing-one__single .table-header {
            position: relative;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 1px solid #d8d8d8;
            padding-bottom: 26px;
            margin-bottom: 29px;
            transition: all 200ms linear;
            transition-delay: 0.1s;
            margin-top: 0;
            padding-top: 0;
            border-top: 0px;
        }
    </style>
@endsection

@section('content')
    <h1 class="d-none">{{ get_seo_page('career')->seo_title ?? 'Career - ' . get_option('title') }}</h1>
    <!-- About One -->
    <section class="about-one" style="padding-bottom: 100px">
        <div class="about-one_ball" style="background-image:url(/frontend/images/icons/ball.html)"></div>
        <div class="about-one_lamp" style="background-image:url(/frontend/images/icons/lamp.png)"></div>
        <div class="container">
            <div class="row align-items-center clearfix">
                <!-- Image Column -->
                <div class="about-one_image-column col-lg-6 col-md-12 col-sm-12">
                    <div class="about-one_image-outer">
                        <div class="about-one_image">
                            <img src="/frontend/images/banners/slider3.png" alt="" />
                        </div>
                    </div>
                </div>

                <!-- Content Column -->
                <div class="about-one_content-column col-lg-6 col-md-12 col-sm-12">
                    <div class="about-one_content-outer">
                        <div class="sec-title">
                            <div class="sec-title_title">
                                <i class="flaticon-wood-1"></i> Excellence you can trust

                            </div>
                            <h2 class="sec-title_heading">Drive Innovation, Drive Your Career</h2>
                            <div class="sec-title_text">
                                At Nataraj Roofing Pvt Ltd, we don’t just sell tyres — we build journeys. Grow your career
                                with opportunities, innovation, and a team driving India forward.
                            </div>
                        </div>

                        <div class="row clearfix">
                            <div class="column col-lg-12 col-sm-12">
                                <ul class="about-one_list">
                                    <li><i class="flaticon-checked-1"></i>Opportunities for personal & professional growth
                                    </li>
                                    <li><i class="flaticon-checked-1"></i>Supportive & collaborative work culture</li>
                                    <li><i class="flaticon-checked-1"></i>Be part of Nepal’s leading tyre solutions brand
                                    </li>
                                    <li><i class="flaticon-checked-1"></i>Innovation-driven environment</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End About One -->


    <!-- Team One -->
    <section class="team-one">
        <div class="container">
            <div class="sec-title">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div class="left-box">
                        <div class="sec-title_title">
                            <i class="flaticon-wood-1"></i> JOB OPENINGS
                        </div>
                        <h2 class="sec-title_heading">
                            Explore Our <br> Latest Positions

                        </h2>
                    </div>
                    <div class="right-box">
                        <div class="sec-title_text">Lorem ipsum dolor sit amet consectetur adipiscing sed do <br> eiusmod
                            tempor incididunt ut labore et dolore magna aliqua.</div>

                    </div>
                </div>
            </div>
            <div class="row clearfix">

                @foreach ($jobs as $item)
                    <!-- Team Block One -->
                    <div class="team-block_one col-lg-4 col-md-4 col-sm-6">
                        <div class="team-block_one-inner h-100">
                            <div class="team-block_one-pattern"
                                style="background-image:url(/frontend/images/background/pattern-9.png)"></div>
                            <div class="team-block_one-content">
                                {{-- <a href="project-detail.html" class="team-block_one-share flaticon-share"></a> --}}
                                {{-- <div class="team-block_one-image">
                                    <a href="project-detail.html">
                                        <img src="{{ $item->imageUrl }}" alt="" />
                                    </a>
                                </div> --}}
                                <h4 class="team-block_one-heading">
                                    <a href="project-detail.html">{{ $item->title }}</a>
                                </h4>
                                <div class="team-block_one-designation">{{ $item->time }}</div>
                                <div class="team-block_one-text">
                                    <div class="table-content">
                                        <ul class="about-one_list">
                                            <li class="mb-0">
                                                <i class="flaticon-checked-1"></i> Salary: {{ $item->salary }}
                                            </li>
                                            <li class="mb-0">
                                                <i class="flaticon-checked-1"></i> Vacancy: {{ $item->no_of_vacancy }}
                                            </li>
                                            <li class="mb-0">
                                                <i class="flaticon-checked-1"></i> Education: {{ $item->education }}
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="about-one_button">
                                    <a href="{{ route('career.show', $item) }}" class="theme-btn btn-style-one">
                                        <span class="btn-wrap">
                                            <span class="text-one">Apply Now</span>
                                            <span class="text-two">Apply Now</span>
                                        </span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </section>
    <!-- End Team One -->






@endsection
