@extends('layouts.frontend.main')

@section('title', 'Apply for ' . $joblist->title)

@section('headerTitle', 'Apply for ' . $joblist->title)

@section('header')
    <li class="breadcrumb-item"> <a href="{{ route('career.index') }}">Career</a> </li>
    <li class="breadcrumb-item"> <a href="{{ route('career.show', $joblist) }}">{{ $joblist->title }}</a> </li>
    <li class="breadcrumb-item active">Apply for {{ $joblist->title }}</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="Apply for {{ $joblist->title }} - {{ get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="Apply for {{ $joblist->title }} - {{ get_option('title') }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('styles')
    <style>
        /* file  */
        .contact-three__file-upload {
            border: 1px solid #bfbfbf;
            padding: 0 30px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 15px;
            height: 80px;
        }

        .contact-three__file-upload:hover {
            border-color: #333;
        }

        .file-upload-icon {
            font-size: 30px;
        }

        .file-upload-text strong {
            font-size: 14px;
            color: var(--erepair-black);
            display: block;
        }

        .file-subtext {
            font-size: 12px;
            color: var(--erepair-gray);
        }
    </style>
@endsection
@section('content')
    <h1 class="d-none">{{ 'Apply for ' . $joblist->title }}</h1>
    <!--Start Checkout Page-->
    <section class="sidebar-page-container left-sidebar">
        <div class="container">
            <div class="row align-items-center clearfix">
                <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar">

                        <div class="project-widget">
                            <ul class="project-detail_info">
                                <li>
                                    <i class="fi fi-rr-users"></i>
                                    Job Title:
                                    <span>{{ $joblist->title }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-folder-tree"></i>
                                    Employment Type:
                                    <span>{{ $joblist->time }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-clock-five"></i>
                                    No. of Vacancy:
                                    <span>{{ $joblist->no_of_vacancy }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-graduation-cap"></i>
                                    Education:
                                    <span>{{ $joblist->education }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-flask-potion"></i>
                                    Experience:
                                    <span>{{ $joblist->experince }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-payroll"></i>
                                    Salary:
                                    <span>{{ $joblist->salary }}</span>
                                </li>
                                <li>
                                    <i class="fi fi-rr-calendar"></i>
                                    Deadline:
                                    <span>{{ $joblist?->deadline?->format('d M, Y') ?? '-' }}</span>
                                </li>
                            </ul>
                        </div>

                    </aside>
                </div>
                <div class="col-xl-8">
                    <div class="billing_details">
                        <div class="billing_title">
                            <h2 class="fs-1">Job Application Form</h2>
                        </div>
                        <div class="contact-form">

                            <form action="{{ route('career.apply', $joblist) }}" enctype="multipart/form-data"
                                method="post">
                                @csrf
                                <div class="row clearfix">
                                    <div class="col-lg-6 col-md-6 col-sm-6 form-group">
                                        <input type="text" name="first_name" value="{{ old('first_name') }}"
                                            placeholder="First name" required="">
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 form-group">
                                        <input type="text" name="last_name" value="{{ old('last_name') }}"
                                            placeholder="Last name" required="">
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <input type="date" name="date_of_birth" value="{{ old('date_of_birth') }}"
                                            placeholder="Date of Birth" required="">
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <div class="billing_input_box">
                                            <div class="select-box">
                                                <select class="wide" name="gender">
                                                    <option data-display="Gender">Gender</option>
                                                    <option {{ old('gender') == 'Male' ? 'selected' : '' }} value="Male">
                                                        Male
                                                    </option>
                                                    <option {{ old('gender') == 'Female' ? 'selected' : '' }}
                                                        value="Female">
                                                        Female</option>
                                                    <option {{ old('gender') == 'Others' ? 'selected' : '' }}
                                                        value="Others">
                                                        Others</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <div class="billing_input_box">
                                            <input name="email" type="email" value="{{ old('email') }}"
                                                placeholder="Email address">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <div class="billing_input_box">
                                            <input type="tel" name="phone_number" value="{{ old('phone_number') }}"
                                                required="" placeholder="Phone">
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <div class="billing_input_box">
                                            <input type="text" name="current_address"
                                                value="{{ old('current_address') }}" placeholder="Current Address">
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <div class="billing_input_box">
                                            <input type="text" name="permanent_address"
                                                value="{{ old('permanent_address') }}" placeholder="Permanent Address">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <div class="billing_input_box">
                                            <input type="text" name="education" value="{{ old('education') }}"
                                                placeholder="Qualification">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                        <div class="billing_input_box">
                                            <input type="text" name="experience" value="{{ old('experience') }}"
                                                placeholder="Experience" required="">
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <div class="billing_input_box">
                                            <textarea placeholder="About yourself" name="about_yourself">{{ old('about_yourself') }}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 form-group">
                                        <div class="contact-three__file-upload contact-three__input-box"
                                            onclick="document.getElementById('cvUpload').click()">
                                            <div class="file-upload-icon">📄</div>
                                            <div class="file-upload-text">
                                                <strong id="fileLabel">Click to Upload Your CV</strong>
                                                <span class="file-subtext">PDF, DOC, DOCX (Max 5MB)</span>
                                            </div>
                                            <input type="file" id="cvUpload" name="resume" accept=".pdf,.doc,.docx"
                                                onchange="updateFileName(this)" hidden />
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                        <!-- Button Box -->
                                        <button type="submit" class="theme-btn btn-style-one">
                                            <span class="btn-wrap">
                                                <span class="text-one">Send Message</span>
                                                <span class="text-two">Send Message</span>
                                            </span>
                                        </button>
                                    </div>
                                </div>




                            </form>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </section>
    <!--End Checkout Page-->

@endsection

@section('scripts')
    <script>
        function updateFileName(input) {
            const fileLabel = document.getElementById("fileLabel");
            fileLabel.textContent =
                input.files.length > 0 ? input.files[0].name : "No file chosen";
        }
    </script>
@endsection
