@extends('layouts.frontend.main')

@section('title', $blog->seo_title ?? $blog->title)

@section('headerTitle', $blog->title)

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('blog.index') }}">Blogs</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ $blog->title }}</li>
@endsection


@section('meta')
    <meta name="keywords" content="{{ $blog->seo_keyword ?? get_option('seo_meta_keywords') }} ">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{ $blog->seo_title ?? $blog->title }} }}">
    <meta name="twitter:image" content="{{ asset('frontend/images/blogs/' . $blog->image) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="{{ $blog->seo_title ?? $blog->title }} }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('frontend/images/blogs/' . $blog->image) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('content')
    <h1 class="d-none">{{ $blog->seo_title ?? $blog->title }}</h1>

    <div class="sidebar-page-container">
        <div class="container">
            <div class="row clearfix">

                <!-- Content Side -->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <div class="blog-detail">
                        <div class="blog-detail_inner">
                            <div class="blog-detail_image">
                                <img src="{{ $blog->imageUrl }}" alt="{{ $blog->title }}" />
                                <div class="blog-detail_content">
                                    <ul class="blog-detail_meta">
                                        <li>
                                            <span class="icon fa fa-user"></span>By Admin
                                        </li>
                                        <li>
                                            <span class="icon fa fa-calendar"></span>
                                            {{ $blog?->created_at?->format('d M, Y') }}
                                        </li>
                                    </ul>
                                    <h3 class="blog-detail_heading">{{ $blog->title }}</h3>
                                    <div class="blog-detail-description">
                                        {!! $blog->description !!}
                                    </div>


                                    <!-- Post Share Options-->
                                    <div class="post-share-options">
                                        <div class="post-share-inner d-flex justify-content-between flex-wrap">
                                            <div class="post-tags">
                                                <span>Share on:</span>
                                                <div class="footer_socials d-inline-block">
                                                    <a class="fa-brands p-0 fa-facebook-f fa-fw"
                                                        href="https://facebook.com/sharer/sharer.php?u={{ request()->url() }}"></a>
                                                    <a class="fa-brands p-0 fa-twitter fa-fw"
                                                        href="https://twitter.com/intent/tweet?text={{ $blog->title }}&url={{ request()->url() }}"></a>
                                                    <a class="fa-brands p-0 fa-linkedin fa-fw"
                                                        href="https://www.linkedin.com/shareArticle?url={{ request()->url() }}&title={{ $blog->title }}"></a>
                                                    <a class="fa-brands p-0 fa-pinterest fa-fw"
                                                        href="https://www.pinterest.com/pin/create/button?url={{ $blog->title }}&media={{ $blog->imageUrl }}&description={{ $blog->title }}"></a>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <!-- Sidebar Side -->
                <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar">

                        <!-- Search Widget -->
                        <div class="sidebar-widget search-box">
                            <div class="widget-content">
                                <h5 class="sidebar-widget_title">Search</h5>
                                <form method="get" action="/blogs">
                                    <div class="form-group">
                                        <input type="search" name="search" placeholder="Search" required>
                                        <button type="submit"><span class="icon fa fa-search"></span></button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <!-- Categories Widget -->
                        <div class="sidebar-widget categories-widget">
                            <div class="widget-content">
                                <h5 class="sidebar-widget_title">Categories</h5>
                                <ul class="service-list_two">
                                    @foreach ($categories as $item)
                                        <li>
                                            <a href="{{ route('blog_category.show', $item) }}">
                                                {{ $item->title }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>

                        <!-- Post Widget -->
                        <div class="sidebar-widget post-widget">
                            <div class="widget-content">
                                <h5 class="sidebar-widget_title">Recent News</h5>

                                @foreach ($blogs->except($blog->id)->take(3) as $item)
                                    <div class="post">
                                        <div class="thumb">
                                            <a href="{{ route('blog.show', $item) }}">
                                                <img src="{{ $item->imageUrl }}" alt="{{ $item->title }}">
                                            </a>
                                        </div>
                                        <div class="post-date">{{ $item?->created_at?->format('d M, Y') }}</div>
                                        <h6>
                                            <a href="{{ route('blog.show', $item) }}">
                                                {{ $item->title }}
                                            </a>
                                        </h6>
                                    </div>
                                @endforeach

                            </div>
                        </div>


                    </aside>
                </div>

            </div>
        </div>
    </div>


@endsection
