@extends('layouts.frontend.main')

@section('headerTitle', 'Blog By ' . $blogCategory->title)

@section('title', 'Blog By ' . $blogCategory->title)

@section('header')
    <li class="breadcrumb-item active">Blog By {{ $blogCategory->title }}</li>
@endsection

@section('meta')
    <meta name="keywords" content="{{ get_option('seo_meta_keywords') }}">
    <meta name="description" content="{{ get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="Blog by {{ $blogCategory->title }} - {{ get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description" content="{{ get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title" content="Blog by {{ $blogCategory->title }} - {{ get_option('title') }}">
    <meta name="og:description" content="{{ get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('content')
    <h1 class="d-none">Blog By {{ $blogCategory->title }} - {{ get_option('title') }}</h1>
    <div class="blog-three">
        <div class="container">
            <div class="row clearfix">

                @foreach ($blogs as $item)
                    <!-- News Block Two -->
                    <div class="news-block_two col-lg-4 col-md-6 col-sm-12">
                        <div class="news-block_two-inner h-100">
                            <div class="news-block_two-image">
                                <a href="{{ route('blog.show', $item) }}">
                                    <img src="{{ $item->imageUrl }}" alt="{{ $item->title }}" />
                                </a>
                            </div>
                            <div class="news-block_two-content">
                                <div class="news-block_two-title">{{ $item?->category?->title }}</div>
                                <h5 class="news-block_two-heading">
                                    <a href="{{ route('blog.show', $item) }}">
                                        {{ $item->title }}
                                    </a>
                                </h5>
                                <ul class="news-block_two-meta">
                                    <li>
                                        <span class="icon fa fa-user"></span>By Admin
                                    </li>
                                    <li>
                                        <span class="icon fa fa-calendar"></span>
                                        {{ $item?->created_at?->format('d M, Y') }}
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                @endforeach


                <!-- Page Pagination Start -->
                {{ $blogs->links() }}
                <!-- Page Pagination End -->
            </div>

        </div>
    </div>
@endsection
