@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Dear {{ $name }},</h1>
<p>
    Thank you for your interest in {{ config('app.name') }} and for requesting information about our products. We appreciate your consideration and are excited to assist you with your product enquiry.
</p>
<p>
    Your interest in our products is valuable to us, and we're committed to providing you with the information you need to make an informed decision.
<p>
    Could you please provide us with more details about your specific requirements? Knowing more about your needs will help us tailor our response to provide you with the most relevant information.
</p>
<p>
    Rest assured that we have received your request and are working diligently to compile the necessary details. We'll get back to you as soon as possible with a comprehensive response.
</p>
<p>
    In the meantime, if you have any additional questions or if there's anything else you'd like to know, please don't hesitate to include them in your reply to this email.
</p>
<p>
    In the meantime, if you have any additional information to provide or any specific questions, please feel free to include them in your response to this email.
</p>
<p>
    Thank you once again for considering {{ config('app.name') }} for your product needs. We look forward to providing you with the information you're seeking.
</p>

{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
    <div class="">
        {{ get_option('mobile_phone_first') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent