@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Dear {{ $name }},</h1>
<p>
    Thank you for applying for our special offer at {{ config('app.name') }}. We appreciate your interest and taking the time to participate.
</p>
<p>
    Your application for the offer has been received and is currently being reviewed. We're excited about the possibility of providing you with this exclusive opportunity.
<p>
    Could you please provide us with any additional information that might be relevant to your application? This could help us tailor our response and ensure the best possible outcome for you.
</p>
<p>
    Rest assured that we're carefully considering all applications and will get back to you with further details as soon as we have completed our evaluation.
</p>
<p>
    In the meantime, if you have any questions or if there's anything else you'd like to communicate, please don't hesitate to include it in your response to this email.
</p>
<p>
    Thank you once again for your interest in {{ config('app.name') }} and for applying for our special offer. We look forward to potentially providing you with this exciting opportunity.
</p>

{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
    <div class="">
        {{ get_option('mobile_phone_first') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent