@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Dear {{ $name }},</h1>
<p>
    Thank you for reaching out to us with your question. We appreciate your interest and would be happy to assist you.
</p>
<p>
    Please provide us with more details about your inquiry so that we can better understand your needs and provide an accurate response.
</p>
<p>
    You can reply to this email or visit our [<a href="{{ route('contact.index') }}">Contact Us</a>] page to share more information.
</p>
<p>
    We're here to help, and we look forward to addressing your question.
</p>

{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
    <div class="">
        {{ get_option('mobile_phone_first') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent