@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Hello !</h1>
<p>
    We wanted to inform you that a user has reached out by applying for a special offer on our website. Here are the application details:
</p>
<p>
<ul>
    <li style="font-size: 16px;list-style: none"> <strong>Personal Details</strong> </span> </li>
    <li style="font-size: 16px;">Full Name : <span style="padding-left: 20px;">{{ $name }}</span> </li>
    <li style="font-size: 16px;">Email : <span style="padding-left: 20px;text-transform: lowercase;">{{ $email }}</span> </li>
    <li style="font-size: 16px;">Phone : <span style="padding-left: 20px;">{{ $phone }}</span> </li>
    <li style="font-size: 16px;">Address : <span style="padding-left: 20px;">{{ $address }}</span> </li>
    @isset($companyName)
    <li style="font-size: 16px;">Company Name : <span style="padding-left: 20px;">{{ $companyName }}</span> </li>
    @endisset
</ul>

</p>

<p>
<ul>
    <li style="font-size: 16px;list-style: none"> <strong>Offer Details</strong> </span> </li>
    <li style="font-size: 16px;">Offer Name: : <span style="padding-left: 20px;text-transform: lowercase;">{{ $offerName }}</span> </li>
    <li style="font-size: 16px;">Offer Price: : <span style="padding-left: 20px;text-transform: lowercase;">{{ $price }}</span> </li>
    <li style="font-size: 16px;">Remarks : <span style="padding-left: 20px;">{{ $remarks }}</span> </li>
</ul>

</p>

<p>
    Kindly review the application and take any required actions. Thank you for your prompt attention.
</p>


{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent