@component('mail::layout')

@slot('header')
@component('mail::header', ['url' => config('app.url')])
{{ config('app.name') }}
@endcomponent
@endslot

<h1>Hello !</h1>
<p>
    We would like to notify you about a new complaint that has been submitted through our website. Here are the enquiry details:
</p>
<p>
<ul>
    <li style="font-size: 16px;list-style: none"> <strong>Personal Details</strong> </span> </li>
    <li style="font-size: 16px;">Full Name : <span style="padding-left: 20px;">{{ $name }}</span> </li>
    <li style="font-size: 16px;">Email : <span style="padding-left: 20px;text-transform: lowercase;">{{ $email }}</span> </li>
    <li style="font-size: 16px;">Phone : <span style="padding-left: 20px;">{{ $phone }}</span> </li>
    <li style="font-size: 16px;">Address : <span style="padding-left: 20px;">{{ $address }}</span> </li>
</ul>

</p>

<p>
<ul>
    <li style="font-size: 16px;list-style: none"> <strong>Product Details</strong> </span> </li>
    <li style="font-size: 16px;">Product Name : <span style="padding-left: 20px;">{{ $productName }}</span> </li>
    <li style="font-size: 16px;">Category : <span style="padding-left: 20px;text-transform: lowercase;">{{ $category }}</span> </li>
    <li style="font-size: 16px;">Date of Purchase : <span style="padding-left: 20px;">{{ $dateOfPurchase }}</span> </li>
    <li style="font-size: 16px;">Complain Type : <span style="padding-left: 20px;">{{ $complainType }}</span> </li>
    <li style="font-size: 16px;">Remarks : <span style="padding-left: 20px;">{{ $remarks }}</span> </li>
</ul>

</p>

@isset($warrentyCard)
@component('mail::button', ['url' => $warrentyCard, 'color' => 'primary'])
Download Warranty Card
@endcomponent
@endisset

@isset($billingCard)
@component('mail::button', ['url' => $billingCard, 'color' => 'primary'])
Download Billing Card
@endcomponent
@endisset

<p>
    Please review the details and take necessary action to respond to this dealer enquiry. Your attention to this matter is important.
</p>


{{-- Subcopy --}}
<div style="margin-top: 40px;font-size: 16px;">
    <div class="">
        Regards,
    </div>
    <div class="">
        {{ config('app.name') }}
    </div>
</div>


{{-- Footer --}}
@slot('footer')
@component('mail::footer')
© {{ date('Y') }} {{ config('app.name') }}.
@lang('All rights reserved.')
@endcomponent
@endslot

@endcomponent
