@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"> <a href="{{ route('videos.index') }}">Video List</a> </li>
    <li class="breadcrumb-item active">View Video</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        Video Details
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <ul class="list-group">
                                @if ($video->imageUrl)
                                    <li class="list-group-item text-center">
                                        <img style="height: 120px; object-fit: contain" src="{{ $video->imageUrl }}"
                                            alt="">
                                    </li>
                                @endif
                                <li class="list-group-item">
                                    <strong class="pe-3">Title : </strong> {{ $video->title }}
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Link : </strong> {{ $video->link }}
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Status : </strong>
                                    @if ($video->status == 1)
                                        <label class="text-success p-2">Active</label>
                                    @else
                                        <label class="text-warning p-2">Disable</label>
                                    @endif
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Created At:</strong>
                                    {{ $video?->created_at?->format('d M, Y') }}
                                </li>

                            </ul>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
