@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('users.index')}}">User List</a></li>
<li class="breadcrumb-item active">Edit User</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Edit User</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="form-group" method="post" action="{{route('users.update', $user)}}">
                        {{csrf_field()}}
                        @method('PUT')
                        <div class="row g-3">
                            <div class="form-group col-6">
                                <label class="control-label">User Name:</label>
                                <input class="form-control" type="text" name="name" value="{{$user->name}}" required>
                            </div>

                            <div class="form-group col-6">
                                <label class="control-label">User Email:</label>
                                <input class="form-control" type="email" name="email" value="{{$user->email}}" required>
                            </div>

                            <div class="form-group col-4">
                                <label class="control-label">New Password:</label>
                                <input class="form-control" type="Password" name="password">
                                <span>Leave empty if You dont want to change password</span>

                            </div>
                            <div class="form-group col-4">
                                <label class="control-label">Choose a Role</label>
                                <select name="role" class="form-control select2 text-capitalize" required>
                                    <option value="">Select One</option>
                                    @foreach($roles as $role)
                                    <option value="{{$role->id}}" {{$user->hasRole($role) == $role->id ?'selected': ''}} class="text-capitalize">{{$role->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-0">
                                <button class="btn btn-primary">Update User</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection