@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('testimonials.index') }}">Testimonial List</a></li>
    <li class="breadcrumb-item active">Show Testimonial</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title">
                        Testimonial Details
                    </span>
                    @can('testimonial-create')
                        <a href="{{ route('testimonials.create') }}" class="btn btn-secondary">Add Testimonial</a>
                    @endcan
                </div>
                <div class="card-body row">
                    <ul class="list-group col-md-6">
                        <li class="list-group-item">
                            <strong>Client Name</strong> : {{ $testimonial->name }}
                        </li>
                        <li class="list-group-item">
                            <strong>Position</strong> : {{ $testimonial->position }}
                        </li>
                        <li class="list-group-item">
                            <strong>Rate</strong> : {{ $testimonial->rate }}
                        </li>
                        <li class="list-group-item">
                            <strong>Message </strong> : {{ $testimonial->message }}
                        </li>

                        <li class="list-group-item">
                            <strong>Created</strong> : {{ $testimonial->created_at->diffForHumans() }}
                        </li>
                        <li class="list-group-item">
                            <strong>Created by</strong> : {{ $testimonial->user->name }}
                        </li>
                    </ul>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Image
                                </div>
                            </div>
                            <div class="card-body">
                                <img src="{{ $testimonial->imageUrl }}" class="w-100"
                                    alt="">
                            </div>
                        </div>
                    </div>
                    @can('testimonial-edit')
                        <a href="{{ route('testimonials.edit', $testimonial) }}" class="btn btn-primary mt-3">
                            Edit This Testimonial
                        </a>
                    @endcan
                </div>
            </div>
        </div>
    </div>
@endsection
