@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('testimonials.index') }}">Testimonial List</a></li>
    <li class="breadcrumb-item active">Add Testimonial</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title">Create Testimonial</span>
                </div>
                <div class="card-body">
                    <div class="params-panel">
                        <form class="row g-3" method="post" enctype="multipart/form-data"
                            action="{{ route('testimonials.store') }}">
                            @csrf
                            <div class="col-md-8">
                                <label class="form-label">Full Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="name" value="{{ old('name') }}"
                                    required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Status <span class="text-danger">*</span> </label>
                                <select class="form-select select2" name="status">
                                    <option value="">Select One</option>
                                    <option {{ old('status') == '1' ? 'selected' : '' }} value="1">Active</option>
                                    <option {{ old('status') == '0' ? 'selected' : '' }} value="0">Disable</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Position <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="position" value="{{ old('position') }}"
                                    required>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Rate <span class="text-danger">*</span> </label>
                                <select class="form-select select2" name="rate">
                                    <option value="">Select One</option>
                                    <option {{ old('rate') == 1 ? 'selected' : '' }} value="1">1 Star</option>
                                    <option {{ old('rate') == 2 ? 'selected' : '' }} value="2">2 Star</option>
                                    <option {{ old('rate') == 3 ? 'selected' : '' }} value="3">3 Star</option>
                                    <option {{ old('rate') == 4 ? 'selected' : '' }} value="4">4 Star</option>
                                    <option {{ old('rate') == 5 ? 'selected' : '' }} value="5">5 Star</option>
                                </select>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Message <span class="text-danger">*</span></label>
                                <textarea class="form-control" type="text" rows="6" name="message" required>{{ old('message') }}</textarea>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Featured Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control dropify" name="image" required>
                            </div>
                            <div class="col-md-0">
                                <button class="btn btn-primary">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
