@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('teams.index')}}">Team List</a></li>
<li class="breadcrumb-item active">Show Team</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12 ">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Team Details
                </span>
                @can('team-create')
                <div class="pull-right">
                    <a href="{{ route('teams.create') }}" class="btn btn-secondary">Add Team</a>
                </div>
                @endcan
            </div>
            <div class="card-body">
                <ul class="list-group col-md-6">
                    <li class="list-group-item">
                        <img src="/frontend/images/teams/{{ $team->image }}" style="height: 200px; width:200px" alt="">
                    </li>
                    <li class="list-group-item">
                        <strong>Full Name</strong> : {{ $team->full_name }}
                    </li>

                    <li class="list-group-item">
                        <strong>Companay</strong> : {{ $team->company_name  }}
                    </li>
                    <li class="list-group-item">
                        <strong>Position</strong> : {{ $team->position  }}
                    </li>

                    <li class="list-group-item">
                        <strong>Created</strong> : {{ $team->created_at->diffForHumans() }}
                    </li>
                </ul>
                @can('testimonial-edit')
                <a href="{{route('teams.edit', $team)}}" class="btn btn-primary mt-3">
                    Edit This Testimoinal
                </a>

                @endcan
            </div>
        </div>
    </div>
</div>
@endsection