@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('suppliers.index') }}">Supplier List</a></li>
    <li class="breadcrumb-item active">Edit Supplier Details</li>
@endsection

@section('content')
    <form class="form-group" enctype="multipart/form-data" method="post" action="{{ route('suppliers.update', $supplier) }}">
        @csrf
        @method('put')
        <div class="row g-4">
            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-header">
                        <span class="panel-title">Edit Supplier Details</span>
                    </div>
                    <div class="card-body">

                        <div class="row g-3">
                            <div class="form-group col-md-8">
                                <label class="form-label">Title <span class="text-danger">*</span> </label>
                                <input class="form-control" type="text" name="title"
                                    value="{{ old('title', $supplier->title) }}" required>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Status <span class="text-danger">*</span> </label>
                                <select class="form-select select2" name="status" required>
                                    <option value="">Select One</option>
                                    <option {{ old('status', $supplier->status) == '1' ? 'selected' : '' }} value="1">
                                        Active
                                    </option>
                                    <option {{ old('status', $supplier->status) == '0' ? 'selected' : '' }} value="0">
                                        Disable
                                    </option>
                                </select>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-body">
                        <div class="row g-3">

                            <div class="col-md-4">
                                <div class="form-group ">
                                    <label class="form-label">Featured Image <span class="text-danger">*</span> </label>
                                    <input class="form-control dropify" type="file"
                                        data-default-file="{{ $supplier->imageUrl }}" name="image" />
                                </div>
                            </div>

                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-12 mt-15">
                                <button type="submit" class="btn btn-primary add_shop">Update</button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
