@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('social_medias.index') }}">Social Media List</a></li>
    <li class="breadcrumb-item active">Add Social Media</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title">Create Social Media</span>
                </div>
                <div class="card-body">
                    <div class="params-panel">
                        <form class="row g-3" method="post" enctype="multipart/form-data"
                            action="{{ route('social_medias.store') }}">
                            @csrf
                            <div class="col-md-4">
                                <label class="form-label">Media <span class="text-danger">*</span> </label>
                                <select class="form-select select2" name="media">
                                    <option value="">Select One</option>
                                    <option {{ old('media') == 'Facebook' ? 'selected' : '' }} value="Facebook">Facebook
                                    </option>
                                    <option {{ old('media') == 'Instagram' ? 'selected' : '' }} value="Instagram">Instagram
                                    </option>
                                    <option {{ old('media') == 'LinkedIn' ? 'selected' : '' }} value="LinkedIn">LinkedIn
                                    </option>
                                    <option {{ old('media') == 'Twitter' ? 'selected' : '' }} value="Twitter">Twitter
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Like </label>
                                <input class="form-control" type="text" name="like" value="{{ old('like') }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Link </label>
                                <input class="form-control" type="text" name="link" value="{{ old('link') }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Date <span class="text-danger">*</span> </label>
                                <input class="form-control" type="date" name="date" value="{{ old('date') }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Status <span class="text-danger">*</span> </label>
                                <select class="form-select select2" name="status">
                                    <option value="">Select One</option>
                                    <option {{ old('status') == '1' ? 'selected' : '' }} value="1">Active</option>
                                    <option {{ old('status') == '0' ? 'selected' : '' }} value="0">Disable</option>
                                </select>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Content <span class="text-danger">*</span></label>
                                <textarea class="form-control" type="text" rows="6" name="content" required>{{ old('content') }}</textarea>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Featured Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control dropify" name="image" required>
                            </div>
                            <div class="col-md-0">
                                <button class="btn btn-primary">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
