@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"> <a href="{{ route('sliders.index') }}">Slider List</a> </li>
    <li class="breadcrumb-item active">Slider Details</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        Slider Details
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Image
                                    </div>
                                </div>
                                <div class="card-body">
                                    <img src="{{ $slider->imageUrl }}" alt="{{ $slider->title }}" class="w-100">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <ul class="list-group">
                                <li class="list-group-item">
                                    <strong class="pe-4">Title : </strong> {{ $slider->title }}
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-4">Subtitle : </strong> {{ $slider->subtitle }}
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-4">Summary : </strong> {{ $slider->summary }}
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-4">Button Link : </strong> {{ $slider->button_link ?? '-' }}
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-4">Button Name : </strong> {{ $slider->button_name ?? '-' }}
                                </li>
                                <li class="list-group-item"> <strong class="pe-4">Created By : </strong>
                                    {{ $slider->user ? $slider->user->name : 'no name' }} </li>
                                <li class="list-group-item"> <strong class="pe-4">Created Date : </strong>
                                    {{ $slider->created_at->format('d M, Y') }} </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
