@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('sliders.index') }}">Banner List</a></li>
    <li class="breadcrumb-item active">Create New Banner</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span class="panel-title">Create New Banner</span>
                </div>
                <div class="card-body">
                    <form class="row g-3" method="post" action="{{ route('sliders.store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="col-md-8">
                            <div class="form-group">
                                <label class="form-label">Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="title" value="{{ old('title') }}"
                                    required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Sub Title <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="subtitle" value="{{ old('subtitle') }}"
                                    required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Button Name</label>
                                <input class="form-control" type="text" name="button_name"
                                    value="{{ old('button_name') }}">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Button Link</label>
                                <input class="form-control" type="text" name="button_link"
                                    value="{{ old('button_link') }}">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Status <span class="text-danger">*</span> </label>
                            <select class="form-select select2" name="status" required>
                                <option value="">Select One</option>
                                <option {{ old('status') == '1' ? 'selected' : '' }} value="1">Active</option>
                                <option {{ old('status') == '0' ? 'selected' : '' }} value="0">Disable</option>
                            </select>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Summary</label>
                                <textarea class="form-control" rows="3" type="text" name="summary">{{ old('summary') }}</textarea>
                                <p class="text-muted mt-1">Use {{ '<br />' }} tag to break the line</p>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label"> Image <span class="text-danger">*</span></label>
                                <input class="form-control dropify" type="file" name="image" required>
                                {{-- <p>The image should be less than 500 KB and less than 1680 x 520 dimension</p> --}}
                            </div>

                        </div>
                        <div class="col-md-12">
                            <button class="btn btn-primary">Submit</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection
