@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('services.index') }}">Services List</a></li>
    <li class="breadcrumb-item active">Edit Service</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title">Edit Service</span>
                </div>
                <div class="card-body">
                    <form class="form-group" method="post" action="{{ route('services.update', $service) }}"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row g-3">
                            <div class="col-md-8">
                                <label class="form-label">Title <span class="text-danger">*</span> </label>
                                <input class="form-control" type="text" name="title" value="{{ $service->title }}"
                                    required>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Status <span class="text-danger">*</span> </label>
                                <select class="form-select select2" name="status">
                                    <option value="">Select One</option>
                                    <option {{ old('status', $service->status) == '1' ? 'selected' : '' }} value="1">
                                        Active</option>
                                    <option {{ old('status', $service->status) == '0' ? 'selected' : '' }} value="0">
                                        Disable</option>
                                </select>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">Summary <span class="text-danger">*</span></label>
                                <textarea class="form-control" type="text" rows="4" name="summary" required>{{ $service->summary }}</textarea>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Chooser an Image:</label>
                                <input class="form-control dropify" type="file" name="image"
                                    data-default-file="{{ $service->imageUrl }}">
                            </div>

                            <div class="col-md-0">
                                <button class="btn btn-primary">Update Service</button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection
