@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('product_requests.index')}}">Product List</a></li>
<li class="breadcrumb-item active">Show Product</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span>
                    Product Details
                </span>
            </div>
            <div class="card-body row">
                <div class="col-md-6">
                    <div class="card panel box box-primary">
                        <div class="card-header">
                            Client Detail
                        </div>
                        <div class="card-body">
                            <ul class="list-group">
                                <li class="list-group-item">
                                    <strong>User Type</strong>: {{ $productRequest->type }}
                                </li>
                                <li class="list-group-item">
                                    <strong>Full Name</strong>: {{ $productRequest->name }}
                                </li>
                                @if ($productRequest->company_name)
                                <li class="list-group-item">
                                    <strong>Company Name</strong>: {{ $productRequest->company_name }}
                                </li>
                                @endif
                                <li class="list-group-item">
                                    <strong>Phone Number</strong>: {{ $productRequest->phone_number }}
                                </li>
                                <li class="list-group-item">
                                    <strong>Email</strong>: {{ $productRequest->email }}
                                </li>
                                <li class="list-group-item">
                                    <strong>Address</strong>: {{ $productRequest->address }}
                                </li>
                                @if ($productRequest->remarks)
                                <li class="list-group-item">
                                    <strong>Description</strong>: {{ $productRequest->remarks }}
                                </li>
                                @endif
                                <li class="list-group-item">
                                    <strong>Created</strong> : {{ $productRequest->created_at->format('d M, Y') }}
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <ul class="list-group col-md-6">
                    <li class="list-group-item">
                        <strong>Product Name</strong> : {{ $productRequest->product->title }}
                    </li>
                    <li class="list-group-item">
                        <strong>Category</strong> : {{ $productRequest->product->category->title }}
                    </li>
                    @if ($productRequest->product->weight)
                    <li class="list-group-item">
                        <strong>Weight</strong> : {{ $productRequest->product->weight . ' ' . $productRequest->product->unit }}
                    </li>
                    @endif
                    @if ($productRequest->product->mrp_price)
                    <li class="list-group-item">
                        <strong> Mrp Price</strong> : Rs. {{ $productRequest->product->mrp_price }}
                    </li>
                    <li class="list-group-item">
                        <strong> Offfered Price</strong> : {{ $productRequest->product->offer_price }}
                    </li>
                    @endif

                    @if ($productRequest->product->in_stock)
                    <li class="list-group-item">
                        <strong>In stock</strong> : {{ $productRequest->product->in_stock }}
                    </li>
                    @endif

                    <li class="list-group-item">
                        <strong>Created</strong> : {{ $productRequest->product->created_at->diffForHumans() }}
                    </li>
                    <li class="list-group-item">
                        <strong>Created by</strong> : {{ $productRequest->product->user->name }}
                    </li>

                    <li class="list-group-item">
                        <strong>Description</strong> : {!! $productRequest->product->description !!}

                    </li>
                </ul>
            </div>
        </div>
    </div>


</div>
@endsection