@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('profile.index') }}">My Profile</a></li>
<li class="breadcrumb-item active">Edit Profile</li>
@endsection

@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card card-default" data-collapsed="0">
			<div class="card-header">
				<div class="card-title">
					Edit Profile
				</div>
			</div>
			<div class="card-body">
				<div class="col-md-8">
					<form action="{{ route('profile.update') }}" class="form-horizontal form-groups-bordered validate" autocomplete="off" enctype="multipart/form-data" method="post" accept-charset="utf-8">
						{{csrf_field()}}
						<div class="form-group mb-3 {{ $errors->has('name') ? ' has-error' : '' }}">
							<div class="row">
								<label class="col-sm-3 control-label">Name <span class="text-danger">*</span></label>
								<div class="col-sm-9">
									<input type="text" class="form-control" name="name" value="{{$profile->name}}" placeholder="Full Name" required>
								</div>
							</div>
						</div>
						<div class="form-group mb-3 {{ $errors->has('address') ? ' has-error' : '' }}">
							<div class="row">
								<label class="col-sm-3 control-label">Address <span class="text-danger">*</span></label>
								<div class="col-sm-9">
									<input type="text" class="form-control" name="address" value="{{ $profile->address }}" required>
								</div>
							</div>
						</div>
						<div class="form-group mb-3 {{ $errors->has('email') ? ' has-error' : '' }}">
							<div class="row">
								<label class="col-sm-3 control-label">Email <span class="text-danger">*</span></label>
								<div class="col-sm-9">
									<input type="email" class="form-control" name="email" value="{{ $profile->email }}" required>
								</div>
							</div>
						</div>
						<div class="form-group mb-3 {{ $errors->has('phone') ? ' has-error' : '' }}">
							<div class="row">
								<label class="col-sm-3 control-label">Phone No.: <span class="text-danger">*</span></label>
								<div class="col-sm-9">
									<input type="text" class="form-control" name="phone" value="{{ $profile->phone }}" required>
								</div>
							</div>
						</div>
						<div class="form-group mb-3 {{ $errors->has('image') ? ' has-error' : '' }}">
							<div class="row">
								<label class="col-sm-3 control-label">Image</label>
								<div class="col-sm-9">
									@if ($profile->profile)
									<input type="file" class="form-control dropify" data-default-file="{{ asset('frontend/images/'.$profile->profile) }}" name="image" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
									@else
									<input type="file" class="form-control dropify" data-default-file="{{ asset('frontend/images/logo.png') }}" name="image" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
									@endif
								</div>
							</div>
						</div>

						<div class="form-group">
							<div class="col-sm-offset-3 col-sm-9">
								<button type="submit" class="btn btn-success">Update Profile</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection