@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item active">Change Profile</li>
@endsection

@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card card-default">
			<div class="card-header">
				<div class="card-title">
					Change Password
				</div>
			</div>
			<div class="card-body">
				<div class="col-md-8">
					<form action="{{ route('password.change') }}" class="form-group" autocomplete="off" enctype="multipart/form-data" method="post" accept-charset="utf-8">
						{{csrf_field()}}
						<div class="row g-3">
							<div class="col-md-12 {{ $errors->has('oldpassword') ? 'has-error' : '' }}">
								<label class="form-label">Old Password <span class="text-danger">*</span></label>
								<input type="password" class="form-control" name="oldpassword" required>
							</div>
							<div class="col-md-6 {{ $errors->has('password') ? 'has-error' : '' }}">
								<label class="form-label">New Password <span class="text-danger">*</span></label>
								<input type="password" class="form-control" name="password" required>
							</div>

							<div class="col-md-6 {{ $errors->has('password_confirmation') ? 'has-error' : '' }}">
								<label class=" form-label">Confirm Password <span class="text-danger">*</span></label>
								<input type="password" class="form-control" name="password_confirmation" required>
							</div>

							<div class="form-group">
								<div class="col-sm-offset-3 col-sm-9">
									<button type="submit" class="btn btn-info">Update Password</button>
								</div>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection