@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('products.index') }}">Product List</a></li>
    <li class="breadcrumb-item active">Show Product</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span>
                        Product Details
                    </span>
                    <div>

                        @can('product-create')
                            <a href="{{ route('products.create') }}" class="btn btn-secondary btn-sm">Add Product</a>
                        @endcan
                        @can('product-edit')
                            <a href="{{ route('products.edit', $product->slug) }}" class="btn btn-primary "> Edit This
                                Product</a>
                        @endcan
                    </div>
                </div>
                <div class="card-body row">
                    <div class="col-md-6">
                        <div class="card panel box box-primary">
                            <div class="card-header">
                                Image
                            </div>
                            <div class="card-body">
                                @if ($product->image)
                                    <img class="img-responsive product_image"
                                        src="/frontend/images/products/{{ $product->image }}" width="100%" height="auto">
                                @else
                                    <img class="img-responsive product_image" src="/frontend/images/profile.png"
                                        width="100%" height="auto">
                                @endif

                            </div>
                        </div>
                        <ul class="list-group col-md-12 mt-4">
                            <li class="list-group-item">
                                <strong>Seo Title</strong> : {{ $product->seo_title }}
                            </li>
                            <li class="list-group-item">
                                <strong>Seo Keyword</strong> : {{ $product->seo_keyword }}
                            </li>
                            <li class="list-group-item">
                                <strong>Seo Description</strong> : {{ $product->seo_description }}
                            </li>
                        </ul>
                    </div>

                    <ul class="list-group col-md-6">
                        <li class="list-group-item">
                            <strong>Title</strong> : {{ $product->title }}
                        </li>
                        <li class="list-group-item">
                            <strong>Category</strong> : {{ $product->category ? $product->category->title : '' }}
                        </li>
                        <li class="list-group-item">
                            <strong>Created</strong> :
                            {{ $product->created_at ? $product->created_at->diffForHumans() : '-' }}
                        </li>
                        <li class="list-group-item">
                            <strong>Created by</strong> : {{ $product->user ? $product->user->name : '-' }}
                        </li>
                        <li class="list-group-item">
                            {!! $product->summary !!}
                        </li>
                        <li class="list-group-item">
                            {!! $product->description !!}
                        </li>
                        <li class="list-group-item">
                            {!! $product->specification !!}
                        </li>
                    </ul>

                    <div class="col-md-12">
                        @if (count(json_decode($product->images)))
                            <div class="row g-4 mt-5 border-top">
                                @foreach (json_decode($product->images) as $item)
                                    <div class="col-md-3">
                                        <img class="w-100" src="/frontend/images/products/{{ $item }}"
                                            alt="">
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>


    </div>
@endsection
